/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.tlv;

import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.AreaIDNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.AutonomousSystemNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.BGP4SubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.BGPLSIdentifierNodeDescriptorSubTLV;
import es.tid.bgp.bgp4.update.tlv.node_link_prefix_descriptor_subTLVs.IGPRouterIDNodeDescriptorSubTLV;

public class LocalNodeDescriptorsTLV
extends BGP4TLVFormat {
    public static final int Local_Node_Descriptors_TLV = 256;
    private AutonomousSystemNodeDescriptorSubTLV autonomousSystemSubTLV;
    private BGPLSIdentifierNodeDescriptorSubTLV BGPLSIDSubTLV;
    private AreaIDNodeDescriptorSubTLV AreaID;
    private IGPRouterIDNodeDescriptorSubTLV IGPRouterID;

    public LocalNodeDescriptorsTLV() {
        this.setTLVType(256);
    }

    public LocalNodeDescriptorsTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 0;
        if (this.autonomousSystemSubTLV != null) {
            this.autonomousSystemSubTLV.encode();
            len += this.autonomousSystemSubTLV.getTotalSubTLVLength();
        }
        if (this.BGPLSIDSubTLV != null) {
            this.BGPLSIDSubTLV.encode();
            len += this.BGPLSIDSubTLV.getTotalSubTLVLength();
        }
        if (this.AreaID != null) {
            this.AreaID.encode();
            len += this.AreaID.getTotalSubTLVLength();
        }
        if (this.IGPRouterID != null) {
            this.IGPRouterID.encode();
            len += this.IGPRouterID.getTotalSubTLVLength();
        }
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        if (this.autonomousSystemSubTLV != null) {
            System.arraycopy(this.autonomousSystemSubTLV.getSubTLV_bytes(), 0, this.tlv_bytes, offset, this.autonomousSystemSubTLV.getTotalSubTLVLength());
            offset += this.autonomousSystemSubTLV.getTotalSubTLVLength();
        }
        if (this.BGPLSIDSubTLV != null) {
            System.arraycopy(this.BGPLSIDSubTLV.getSubTLV_bytes(), 0, this.tlv_bytes, offset, this.BGPLSIDSubTLV.getTotalSubTLVLength());
            offset += this.BGPLSIDSubTLV.getTotalSubTLVLength();
        }
        if (this.AreaID != null) {
            System.arraycopy(this.AreaID.getSubTLV_bytes(), 0, this.tlv_bytes, offset, this.AreaID.getTotalSubTLVLength());
            offset += this.AreaID.getTotalSubTLVLength();
        }
        if (this.IGPRouterID != null) {
            System.arraycopy(this.IGPRouterID.getSubTLV_bytes(), 0, this.tlv_bytes, offset, this.IGPRouterID.getTotalSubTLVLength());
            offset += this.IGPRouterID.getTotalSubTLVLength();
        }
    }

    public void decode() {
        boolean fin = false;
        int offset = 4;
        while (!fin) {
            int subtlvType = BGP4SubTLV.getType(this.tlv_bytes, offset);
            int subtlvLength = BGP4SubTLV.getTotalSubTLVLength(this.tlv_bytes, offset);
            switch (subtlvType) {
                case 512: {
                    this.autonomousSystemSubTLV = new AutonomousSystemNodeDescriptorSubTLV(this.tlv_bytes, offset);
                    break;
                }
                case 513: {
                    this.BGPLSIDSubTLV = new BGPLSIdentifierNodeDescriptorSubTLV(this.tlv_bytes, offset);
                    break;
                }
                case 514: {
                    this.AreaID = new AreaIDNodeDescriptorSubTLV(this.tlv_bytes, offset);
                    break;
                }
                case 515: {
                    this.IGPRouterID = new IGPRouterIDNodeDescriptorSubTLV(this.tlv_bytes, offset);
                    break;
                }
                default: {
                    log.warn("Local Node Descriptor subtlv Unknown, " + subtlvType);
                }
            }
            if ((offset += subtlvLength) >= this.TLVValueLength) {
                fin = true;
                continue;
            }
            log.debug("sigo leyendo NodeDescriptorsSubTLV ");
        }
    }

    public AutonomousSystemNodeDescriptorSubTLV getAutonomousSystemSubTLV() {
        return this.autonomousSystemSubTLV;
    }

    public void setAutonomousSystemSubTLV(AutonomousSystemNodeDescriptorSubTLV autonomousSystemSubTLV) {
        this.autonomousSystemSubTLV = autonomousSystemSubTLV;
    }

    public BGPLSIdentifierNodeDescriptorSubTLV getBGPLSIDSubTLV() {
        return this.BGPLSIDSubTLV;
    }

    public void setBGPLSIDSubTLV(BGPLSIdentifierNodeDescriptorSubTLV bGPLSIDSubTLV) {
        this.BGPLSIDSubTLV = bGPLSIDSubTLV;
    }

    public AreaIDNodeDescriptorSubTLV getAreaID() {
        return this.AreaID;
    }

    public void setAreaID(AreaIDNodeDescriptorSubTLV areaID) {
        this.AreaID = areaID;
    }

    public IGPRouterIDNodeDescriptorSubTLV getIGPRouterID() {
        return this.IGPRouterID;
    }

    public void setIGPRouterID(IGPRouterIDNodeDescriptorSubTLV iGPRouterID) {
        this.IGPRouterID = iGPRouterID;
    }

    public static int getLocalNodeDescriptorsTlv() {
        return 256;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        if (this.autonomousSystemSubTLV != null) {
            sb.append("\n\t> " + this.autonomousSystemSubTLV.toString() + "\n");
        }
        if (this.BGPLSIDSubTLV != null) {
            sb.append("\n\t> " + this.BGPLSIDSubTLV.toString() + "\n");
        }
        if (this.AreaID != null) {
            sb.append("\n\t> " + this.AreaID.toString() + "\n");
        }
        if (this.IGPRouterID != null) {
            sb.append("\n\t> " + this.IGPRouterID.toString() + "\n");
        }
        return sb.toString();
    }
}

