/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields.pathAttributes;

import es.tid.bgp.bgp4.update.fields.PathAttribute;
import es.tid.bgp.bgp4.update.tlv.BGP4TLVFormat;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.AdministrativeGroupLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.DefaultTEMetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IGPFlagBitsPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDLocalNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IPv4RouterIDRemoteNodeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.IS_IS_AreaIdentifierNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.LinkProtectionTypeLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MF_OTPAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaxReservableBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MaximumLinkBandwidthLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.MetricLinkAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.NodeFlagBitsNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.NodeNameNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.OSPFForwardingAddressPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.PrefixMetricPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.RouteTagPrefixAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.SharedRiskLinkGroupAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.SidLabelNodeAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.TransceiverClassAndAppAttribTLV;
import es.tid.bgp.bgp4.update.tlv.linkstate_attribute_tlvs.UnreservedBandwidthLinkAttribTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MalformedOSPFSubTLVException;

public class LinkStateAttribute
extends PathAttribute {
    AdministrativeGroupLinkAttribTLV administrativeGroupTLV;
    MaximumLinkBandwidthLinkAttribTLV maximumLinkBandwidthTLV;
    MaxReservableBandwidthLinkAttribTLV maxReservableBandwidthTLV;
    UnreservedBandwidthLinkAttribTLV unreservedBandwidthTLV;
    LinkProtectionTypeLinkAttribTLV linkProtectionTLV;
    MetricLinkAttribTLV metricTLV;
    AvailableLabels availableLabels;
    IPv4RouterIDLocalNodeLinkAttribTLV IPv4RouterIDLocalNodeLATLV;
    IPv4RouterIDRemoteNodeLinkAttribTLV IPv4RouterIDRemoteNodeLATLV;
    DefaultTEMetricLinkAttribTLV TEMetricTLV;
    SharedRiskLinkGroupAttribTLV SharedRiskLinkGroupATLV;
    TransceiverClassAndAppAttribTLV TransceiverClassAndAppATLV;
    MF_OTPAttribTLV MF_OTP_ATLV;
    NodeFlagBitsNodeAttribTLV nodeFlagBitsTLV;
    NodeNameNodeAttribTLV nodeNameTLV;
    IS_IS_AreaIdentifierNodeAttribTLV areaIDTLV;
    SidLabelNodeAttribTLV sidLabelTLV;
    IGPFlagBitsPrefixAttribTLV igpFlagBitsTLV;
    RouteTagPrefixAttribTLV routeTagTLV;
    PrefixMetricPrefixAttribTLV prefixMetricTLV;
    OSPFForwardingAddressPrefixAttribTLV OSPFForwardingAddrTLV;

    public LinkStateAttribute() {
        this.optionalBit = true;
        this.transitiveBit = false;
        this.typeCode = 29;
    }

    public LinkStateAttribute(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.pathAttributeLength = 0;
        if (this.maximumLinkBandwidthTLV != null) {
            this.maximumLinkBandwidthTLV.encode();
            this.pathAttributeLength += this.maximumLinkBandwidthTLV.getTotalTLVLength();
        }
        if (this.maxReservableBandwidthTLV != null) {
            this.maxReservableBandwidthTLV.encode();
            this.pathAttributeLength += this.maxReservableBandwidthTLV.getTotalTLVLength();
        }
        if (this.unreservedBandwidthTLV != null) {
            this.unreservedBandwidthTLV.encode();
            this.pathAttributeLength += this.unreservedBandwidthTLV.getTotalTLVLength();
        }
        if (this.metricTLV != null) {
            this.metricTLV.encode();
            this.pathAttributeLength += this.metricTLV.getTotalTLVLength();
        }
        if (this.administrativeGroupTLV != null) {
            this.administrativeGroupTLV.encode();
            this.pathAttributeLength += this.administrativeGroupTLV.getTotalTLVLength();
        }
        if (this.linkProtectionTLV != null) {
            this.linkProtectionTLV.encode();
            this.pathAttributeLength += this.linkProtectionTLV.getTotalTLVLength();
        }
        if (this.IPv4RouterIDLocalNodeLATLV != null) {
            this.IPv4RouterIDLocalNodeLATLV.encode();
            this.pathAttributeLength += this.IPv4RouterIDLocalNodeLATLV.getTotalTLVLength();
        }
        if (this.IPv4RouterIDRemoteNodeLATLV != null) {
            this.IPv4RouterIDRemoteNodeLATLV.encode();
            this.pathAttributeLength += this.IPv4RouterIDRemoteNodeLATLV.getTotalTLVLength();
        }
        if (this.TEMetricTLV != null) {
            this.TEMetricTLV.encode();
            this.pathAttributeLength += this.TEMetricTLV.getTotalTLVLength();
        }
        if (this.SharedRiskLinkGroupATLV != null) {
            this.SharedRiskLinkGroupATLV.encode();
            this.pathAttributeLength += this.SharedRiskLinkGroupATLV.getTotalTLVLength();
        }
        if (this.TransceiverClassAndAppATLV != null) {
            this.TransceiverClassAndAppATLV.encode();
            this.pathAttributeLength += this.TransceiverClassAndAppATLV.getTotalTLVLength();
        }
        if (this.MF_OTP_ATLV != null) {
            this.MF_OTP_ATLV.encode();
            this.pathAttributeLength += this.MF_OTP_ATLV.getTotalTLVLength();
        }
        if (this.nodeFlagBitsTLV != null) {
            this.nodeFlagBitsTLV.encode();
            this.pathAttributeLength += this.nodeFlagBitsTLV.getTotalTLVLength();
        }
        if (this.nodeNameTLV != null) {
            this.nodeNameTLV.encode();
            this.pathAttributeLength += this.nodeNameTLV.getTotalTLVLength();
        }
        if (this.areaIDTLV != null) {
            this.areaIDTLV.encode();
            this.pathAttributeLength += this.areaIDTLV.getTotalTLVLength();
        }
        if (this.sidLabelTLV != null) {
            this.sidLabelTLV.encode();
            this.pathAttributeLength += this.sidLabelTLV.getTotalTLVLength();
        }
        if (this.igpFlagBitsTLV != null) {
            this.igpFlagBitsTLV.encode();
            this.pathAttributeLength += this.igpFlagBitsTLV.getTotalTLVLength();
        }
        if (this.routeTagTLV != null) {
            this.routeTagTLV.encode();
            this.pathAttributeLength += this.routeTagTLV.getTotalTLVLength();
        }
        if (this.prefixMetricTLV != null) {
            this.prefixMetricTLV.encode();
            this.pathAttributeLength += this.prefixMetricTLV.getTotalTLVLength();
        }
        if (this.OSPFForwardingAddrTLV != null) {
            this.OSPFForwardingAddrTLV.encode();
            this.pathAttributeLength += this.OSPFForwardingAddrTLV.getTotalTLVLength();
        }
        if (this.availableLabels != null) {
            try {
                this.availableLabels.encode();
            }
            catch (MalformedOSPFSubTLVException e) {
                e.printStackTrace();
            }
            this.pathAttributeLength += this.availableLabels.getTotalTLVLength();
        }
        this.setPathAttributeLength(this.pathAttributeLength);
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int offset = this.mandatoryLength;
        if (this.maximumLinkBandwidthTLV != null) {
            System.arraycopy(this.maximumLinkBandwidthTLV.getTlv_bytes(), 0, this.bytes, offset, this.maximumLinkBandwidthTLV.getTotalTLVLength());
            offset += this.maximumLinkBandwidthTLV.getTotalTLVLength();
        }
        if (this.maxReservableBandwidthTLV != null) {
            System.arraycopy(this.maxReservableBandwidthTLV.getTlv_bytes(), 0, this.bytes, offset, this.maxReservableBandwidthTLV.getTotalTLVLength());
            offset += this.maxReservableBandwidthTLV.getTotalTLVLength();
        }
        if (this.unreservedBandwidthTLV != null) {
            System.arraycopy(this.unreservedBandwidthTLV.getTlv_bytes(), 0, this.bytes, offset, this.unreservedBandwidthTLV.getTotalTLVLength());
            offset += this.unreservedBandwidthTLV.getTotalTLVLength();
        }
        if (this.metricTLV != null) {
            System.arraycopy(this.metricTLV.getTlv_bytes(), 0, this.bytes, offset, this.metricTLV.getTotalTLVLength());
            offset += this.metricTLV.getTotalTLVLength();
        }
        if (this.administrativeGroupTLV != null) {
            System.arraycopy(this.administrativeGroupTLV.getTlv_bytes(), 0, this.bytes, offset, this.administrativeGroupTLV.getTotalTLVLength());
            offset += this.administrativeGroupTLV.getTotalTLVLength();
        }
        if (this.linkProtectionTLV != null) {
            System.arraycopy(this.linkProtectionTLV.getTlv_bytes(), 0, this.bytes, offset, this.linkProtectionTLV.getTotalTLVLength());
            offset += this.linkProtectionTLV.getTotalTLVLength();
        }
        if (this.IPv4RouterIDLocalNodeLATLV != null) {
            System.arraycopy(this.IPv4RouterIDLocalNodeLATLV.getTlv_bytes(), 0, this.bytes, offset, this.IPv4RouterIDLocalNodeLATLV.getTotalTLVLength());
            offset += this.IPv4RouterIDLocalNodeLATLV.getTotalTLVLength();
        }
        if (this.IPv4RouterIDRemoteNodeLATLV != null) {
            System.arraycopy(this.IPv4RouterIDRemoteNodeLATLV.getTlv_bytes(), 0, this.bytes, offset, this.IPv4RouterIDRemoteNodeLATLV.getTotalTLVLength());
            offset += this.IPv4RouterIDRemoteNodeLATLV.getTotalTLVLength();
        }
        if (this.TEMetricTLV != null) {
            System.arraycopy(this.TEMetricTLV.getTlv_bytes(), 0, this.bytes, offset, this.TEMetricTLV.getTotalTLVLength());
            offset += this.TEMetricTLV.getTotalTLVLength();
        }
        if (this.SharedRiskLinkGroupATLV != null) {
            System.arraycopy(this.SharedRiskLinkGroupATLV.getTlv_bytes(), 0, this.bytes, offset, this.SharedRiskLinkGroupATLV.getTotalTLVLength());
            offset += this.SharedRiskLinkGroupATLV.getTotalTLVLength();
        }
        if (this.TransceiverClassAndAppATLV != null) {
            System.arraycopy(this.TransceiverClassAndAppATLV.getTlv_bytes(), 0, this.bytes, offset, this.TransceiverClassAndAppATLV.getTotalTLVLength());
            offset += this.TransceiverClassAndAppATLV.getTotalTLVLength();
        }
        if (this.MF_OTP_ATLV != null) {
            System.arraycopy(this.MF_OTP_ATLV.getTlv_bytes(), 0, this.bytes, offset, this.MF_OTP_ATLV.getTotalTLVLength());
            offset += this.MF_OTP_ATLV.getTotalTLVLength();
        }
        if (this.areaIDTLV != null) {
            System.arraycopy(this.areaIDTLV.getTlv_bytes(), 0, this.bytes, offset, this.areaIDTLV.getTotalTLVLength());
            offset += this.areaIDTLV.getTotalTLVLength();
        }
        if (this.nodeFlagBitsTLV != null) {
            System.arraycopy(this.nodeFlagBitsTLV.getTlv_bytes(), 0, this.bytes, offset, this.nodeFlagBitsTLV.getTotalTLVLength());
            offset += this.nodeFlagBitsTLV.getTotalTLVLength();
        }
        if (this.nodeNameTLV != null) {
            System.arraycopy(this.nodeNameTLV.getTlv_bytes(), 0, this.bytes, offset, this.nodeNameTLV.getTotalTLVLength());
            offset += this.nodeNameTLV.getTotalTLVLength();
        }
        if (this.sidLabelTLV != null) {
            System.arraycopy(this.sidLabelTLV.getTlv_bytes(), 0, this.bytes, offset, this.sidLabelTLV.getTotalTLVLength());
            offset += this.sidLabelTLV.getTotalTLVLength();
        }
        if (this.igpFlagBitsTLV != null) {
            System.arraycopy(this.igpFlagBitsTLV.getTlv_bytes(), 0, this.bytes, offset, this.igpFlagBitsTLV.getTotalTLVLength());
            offset += this.igpFlagBitsTLV.getTotalTLVLength();
        }
        if (this.routeTagTLV != null) {
            System.arraycopy(this.routeTagTLV.getTlv_bytes(), 0, this.bytes, offset, this.routeTagTLV.getTotalTLVLength());
            offset += this.routeTagTLV.getTotalTLVLength();
        }
        if (this.prefixMetricTLV != null) {
            System.arraycopy(this.prefixMetricTLV.getTlv_bytes(), 0, this.bytes, offset, this.prefixMetricTLV.getTotalTLVLength());
            offset += this.prefixMetricTLV.getTotalTLVLength();
        }
        if (this.OSPFForwardingAddrTLV != null) {
            System.arraycopy(this.OSPFForwardingAddrTLV.getTlv_bytes(), 0, this.bytes, offset, this.OSPFForwardingAddrTLV.getTotalTLVLength());
            offset += this.OSPFForwardingAddrTLV.getTotalTLVLength();
        }
        if (this.availableLabels != null) {
            System.arraycopy(this.availableLabels.getTlv_bytes(), 0, this.bytes, offset, this.availableLabels.getTotalTLVLength());
            offset += this.availableLabels.getTotalTLVLength();
        }
    }

    public void decode() {
        boolean fin = false;
        int offset = this.mandatoryLength;
        while (!fin) {
            int TLVType = BGP4TLVFormat.getType(this.bytes, offset);
            int TLVLength = BGP4TLVFormat.getTotalTLVLength(this.bytes, offset);
            switch (TLVType) {
                case 1090: {
                    this.maxReservableBandwidthTLV = new MaxReservableBandwidthLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1089: {
                    this.maximumLinkBandwidthTLV = new MaximumLinkBandwidthLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1091: {
                    this.unreservedBandwidthTLV = new UnreservedBandwidthLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1095: {
                    this.metricTLV = new MetricLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1088: {
                    this.administrativeGroupTLV = new AdministrativeGroupLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1093: {
                    this.linkProtectionTLV = new LinkProtectionTypeLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1028: {
                    this.IPv4RouterIDLocalNodeLATLV = new IPv4RouterIDLocalNodeLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1030: {
                    this.IPv4RouterIDRemoteNodeLATLV = new IPv4RouterIDRemoteNodeLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1092: {
                    this.TEMetricTLV = new DefaultTEMetricLinkAttribTLV(this.bytes, offset);
                    break;
                }
                case 1096: {
                    this.SharedRiskLinkGroupATLV = new SharedRiskLinkGroupAttribTLV(this.bytes, offset);
                    break;
                }
                case 2498: {
                    this.TransceiverClassAndAppATLV = new TransceiverClassAndAppAttribTLV(this.bytes, offset);
                    break;
                }
                case 2499: {
                    this.MF_OTP_ATLV = new MF_OTPAttribTLV(this.bytes, offset);
                    break;
                }
                case 1200: {
                    try {
                        this.availableLabels = new AvailableLabels(this.bytes, offset);
                    }
                    catch (MalformedOSPFSubTLVException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1027: {
                    this.areaIDTLV = new IS_IS_AreaIdentifierNodeAttribTLV(this.bytes, offset);
                    break;
                }
                case 1024: {
                    this.nodeFlagBitsTLV = new NodeFlagBitsNodeAttribTLV(this.bytes, offset);
                    break;
                }
                case 1026: {
                    this.nodeNameTLV = new NodeNameNodeAttribTLV(this.bytes, offset);
                    break;
                }
                case 1069: {
                    this.sidLabelTLV = new SidLabelNodeAttribTLV(this.bytes, offset);
                    break;
                }
                case 1152: {
                    this.igpFlagBitsTLV = new IGPFlagBitsPrefixAttribTLV(this.bytes, offset);
                    break;
                }
                case 1156: {
                    this.OSPFForwardingAddrTLV = new OSPFForwardingAddressPrefixAttribTLV(this.bytes, offset);
                    break;
                }
                case 1155: {
                    this.prefixMetricTLV = new PrefixMetricPrefixAttribTLV(this.bytes, offset);
                    break;
                }
                case 1153: {
                    this.routeTagTLV = new RouteTagPrefixAttribTLV(this.bytes, offset);
                    break;
                }
                default: {
                    log.warn("Unknown TLV found: " + TLVType);
                }
            }
            if ((offset += TLVLength) < this.pathAttributeLength) continue;
            fin = true;
        }
    }

    public IGPFlagBitsPrefixAttribTLV getIgpFlagBitsTLV() {
        return this.igpFlagBitsTLV;
    }

    public void setIgpFlagBitsTLV(IGPFlagBitsPrefixAttribTLV igpFlagBitsTLV) {
        this.igpFlagBitsTLV = igpFlagBitsTLV;
    }

    public RouteTagPrefixAttribTLV getRouteTagTLV() {
        return this.routeTagTLV;
    }

    public void setRouteTagTLV(RouteTagPrefixAttribTLV routeTagTLV) {
        this.routeTagTLV = routeTagTLV;
    }

    public PrefixMetricPrefixAttribTLV getPrefixMetricTLV() {
        return this.prefixMetricTLV;
    }

    public void setPrefixMetricTLV(PrefixMetricPrefixAttribTLV prefixMetricTLV) {
        this.prefixMetricTLV = prefixMetricTLV;
    }

    public OSPFForwardingAddressPrefixAttribTLV getOSPFForwardingAddrTLV() {
        return this.OSPFForwardingAddrTLV;
    }

    public void setOSPFForwardingAddrTLV(OSPFForwardingAddressPrefixAttribTLV oSPFForwardingAddrTLV) {
        this.OSPFForwardingAddrTLV = oSPFForwardingAddrTLV;
    }

    public MaximumLinkBandwidthLinkAttribTLV getMaximumLinkBandwidthTLV() {
        return this.maximumLinkBandwidthTLV;
    }

    public void setMaximumLinkBandwidthTLV(MaximumLinkBandwidthLinkAttribTLV maximumLinkBandwidthTLV) {
        this.maximumLinkBandwidthTLV = maximumLinkBandwidthTLV;
    }

    public MaxReservableBandwidthLinkAttribTLV getMaxReservableBandwidthTLV() {
        return this.maxReservableBandwidthTLV;
    }

    public void setMaxReservableBandwidthTLV(MaxReservableBandwidthLinkAttribTLV maxReservableBandwidthTLV) {
        this.maxReservableBandwidthTLV = maxReservableBandwidthTLV;
    }

    public UnreservedBandwidthLinkAttribTLV getUnreservedBandwidthTLV() {
        return this.unreservedBandwidthTLV;
    }

    public void setUnreservedBandwidthTLV(UnreservedBandwidthLinkAttribTLV unreservedBandwidthTLV) {
        this.unreservedBandwidthTLV = unreservedBandwidthTLV;
    }

    public MetricLinkAttribTLV getMetricTLV() {
        return this.metricTLV;
    }

    public void setMetricTLV(MetricLinkAttribTLV metricTLV) {
        this.metricTLV = metricTLV;
    }

    public AdministrativeGroupLinkAttribTLV getAdministrativeGroupTLV() {
        return this.administrativeGroupTLV;
    }

    public void setAdministrativeGroupTLV(AdministrativeGroupLinkAttribTLV administrativeGroupTLV) {
        this.administrativeGroupTLV = administrativeGroupTLV;
    }

    public LinkProtectionTypeLinkAttribTLV getLinkProtectionTLV() {
        return this.linkProtectionTLV;
    }

    public void setLinkProtectionTLV(LinkProtectionTypeLinkAttribTLV linkProtectionTLV) {
        this.linkProtectionTLV = linkProtectionTLV;
    }

    public IPv4RouterIDLocalNodeLinkAttribTLV getIPv4RouterIDLocalNodeLATLV() {
        return this.IPv4RouterIDLocalNodeLATLV;
    }

    public void setIPv4RouterIDLocalNodeLATLV(IPv4RouterIDLocalNodeLinkAttribTLV iPv4RouterIDLocalNodeLATLV) {
        this.IPv4RouterIDLocalNodeLATLV = iPv4RouterIDLocalNodeLATLV;
    }

    public IPv4RouterIDRemoteNodeLinkAttribTLV getIPv4RouterIDRemoteNodeLATLV() {
        return this.IPv4RouterIDRemoteNodeLATLV;
    }

    public void setIPv4RouterIDRemoteNodeLATLV(IPv4RouterIDRemoteNodeLinkAttribTLV iPv4RouterIDRemoteNodeLATLV) {
        this.IPv4RouterIDRemoteNodeLATLV = iPv4RouterIDRemoteNodeLATLV;
    }

    public DefaultTEMetricLinkAttribTLV getTEMetricTLV() {
        return this.TEMetricTLV;
    }

    public void setTEMetricTLV(DefaultTEMetricLinkAttribTLV tEMetricTLV) {
        this.TEMetricTLV = tEMetricTLV;
    }

    public NodeFlagBitsNodeAttribTLV getNodeFlagBitsTLV() {
        return this.nodeFlagBitsTLV;
    }

    public SharedRiskLinkGroupAttribTLV getSharedRiskLinkGroupATLV() {
        return this.SharedRiskLinkGroupATLV;
    }

    public void setSharedRiskLinkGroupATLV(SharedRiskLinkGroupAttribTLV sharedRiskLinkGroupATLV) {
        this.SharedRiskLinkGroupATLV = sharedRiskLinkGroupATLV;
    }

    public TransceiverClassAndAppAttribTLV getTransceiverClassAndAppATLV() {
        return this.TransceiverClassAndAppATLV;
    }

    public void setTransceiverClassAndAppATLV(TransceiverClassAndAppAttribTLV transceiverClassAndAppATLV) {
        this.TransceiverClassAndAppATLV = transceiverClassAndAppATLV;
    }

    public MF_OTPAttribTLV getMF_OTP_ATLV() {
        return this.MF_OTP_ATLV;
    }

    public void setMF_OTP_ATLV(MF_OTPAttribTLV mF_OTP_ATLV) {
        this.MF_OTP_ATLV = mF_OTP_ATLV;
    }

    public void setNodeFlagBitsTLV(NodeFlagBitsNodeAttribTLV nodeFlagBitsTLV) {
        this.nodeFlagBitsTLV = nodeFlagBitsTLV;
    }

    public SidLabelNodeAttribTLV getSidLabelTLV() {
        return this.sidLabelTLV;
    }

    public void setSidLabelTLV(SidLabelNodeAttribTLV sidLabelTLV) {
        this.sidLabelTLV = sidLabelTLV;
    }

    public NodeNameNodeAttribTLV getNodeNameTLV() {
        return this.nodeNameTLV;
    }

    public void setNodeNameTLV(NodeNameNodeAttribTLV nodeNameTLV) {
        this.nodeNameTLV = nodeNameTLV;
    }

    public IS_IS_AreaIdentifierNodeAttribTLV getAreaIDTLV() {
        return this.areaIDTLV;
    }

    public void setAreaIDTLV(IS_IS_AreaIdentifierNodeAttribTLV areaIDTLV) {
        this.areaIDTLV = areaIDTLV;
    }

    public AvailableLabels getAvailableLabels() {
        return this.availableLabels;
    }

    public void setAvailableLabels(AvailableLabels availableLabels) {
        this.availableLabels = availableLabels;
    }

    public String toString() {
        return "LinkStateAttribute [administrativeGroupTLV=" + String.valueOf(this.administrativeGroupTLV) + ", maximumLinkBandwidthTLV=" + String.valueOf(this.maximumLinkBandwidthTLV) + ", maxReservableBandwidthTLV=" + String.valueOf(this.maxReservableBandwidthTLV) + ", unreservedBandwidthTLV=" + String.valueOf(this.unreservedBandwidthTLV) + ", linkProtectionTLV=" + String.valueOf(this.linkProtectionTLV) + ", metricTLV=" + String.valueOf(this.metricTLV) + ", availableLabels=, IPv4RouterIDLocalNodeLATLV=" + String.valueOf(this.IPv4RouterIDLocalNodeLATLV) + ", IPv4RouterIDRemoteNodeLATLV=" + String.valueOf(this.IPv4RouterIDRemoteNodeLATLV) + ", TEMetricTLV=" + String.valueOf(this.TEMetricTLV) + ", SharedRiskLinkGroupATLV=" + String.valueOf(this.SharedRiskLinkGroupATLV) + ", TransceiverClassAndAppATLV=" + String.valueOf(this.TransceiverClassAndAppATLV) + ", nodeFlagBitsTLV=" + String.valueOf(this.nodeFlagBitsTLV) + ", nodeNameTLV=" + String.valueOf(this.nodeNameTLV) + ", areaIDTLV=" + String.valueOf(this.areaIDTLV) + ", sidLabelTLV=" + String.valueOf(this.sidLabelTLV) + ", igpFlagBitsTLV=" + String.valueOf(this.igpFlagBitsTLV) + ", routeTagTLV=" + String.valueOf(this.routeTagTLV) + ", prefixMetricTLV=" + String.valueOf(this.prefixMetricTLV) + ", OSPFForwardingAddrTLV=" + String.valueOf(this.OSPFForwardingAddrTLV) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.IPv4RouterIDLocalNodeLATLV == null ? 0 : this.IPv4RouterIDLocalNodeLATLV.hashCode());
        result = 31 * result + (this.IPv4RouterIDRemoteNodeLATLV == null ? 0 : this.IPv4RouterIDRemoteNodeLATLV.hashCode());
        result = 31 * result + (this.OSPFForwardingAddrTLV == null ? 0 : this.OSPFForwardingAddrTLV.hashCode());
        result = 31 * result + (this.SharedRiskLinkGroupATLV == null ? 0 : this.SharedRiskLinkGroupATLV.hashCode());
        result = 31 * result + (this.TEMetricTLV == null ? 0 : this.TEMetricTLV.hashCode());
        result = 31 * result + (this.TransceiverClassAndAppATLV == null ? 0 : this.TransceiverClassAndAppATLV.hashCode());
        result = 31 * result + (this.administrativeGroupTLV == null ? 0 : this.administrativeGroupTLV.hashCode());
        result = 31 * result + (this.areaIDTLV == null ? 0 : this.areaIDTLV.hashCode());
        result = 31 * result + (this.igpFlagBitsTLV == null ? 0 : this.igpFlagBitsTLV.hashCode());
        result = 31 * result + (this.linkProtectionTLV == null ? 0 : this.linkProtectionTLV.hashCode());
        result = 31 * result + (this.maxReservableBandwidthTLV == null ? 0 : this.maxReservableBandwidthTLV.hashCode());
        result = 31 * result + (this.maximumLinkBandwidthTLV == null ? 0 : this.maximumLinkBandwidthTLV.hashCode());
        result = 31 * result + (this.metricTLV == null ? 0 : this.metricTLV.hashCode());
        result = 31 * result + (this.nodeFlagBitsTLV == null ? 0 : this.nodeFlagBitsTLV.hashCode());
        result = 31 * result + (this.nodeNameTLV == null ? 0 : this.nodeNameTLV.hashCode());
        result = 31 * result + (this.prefixMetricTLV == null ? 0 : this.prefixMetricTLV.hashCode());
        result = 31 * result + (this.routeTagTLV == null ? 0 : this.routeTagTLV.hashCode());
        result = 31 * result + (this.sidLabelTLV == null ? 0 : this.sidLabelTLV.hashCode());
        result = 31 * result + (this.unreservedBandwidthTLV == null ? 0 : this.unreservedBandwidthTLV.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkStateAttribute other = (LinkStateAttribute)obj;
        if (this.IPv4RouterIDLocalNodeLATLV == null ? other.IPv4RouterIDLocalNodeLATLV != null : !this.IPv4RouterIDLocalNodeLATLV.equals(other.IPv4RouterIDLocalNodeLATLV)) {
            return false;
        }
        if (this.IPv4RouterIDRemoteNodeLATLV == null ? other.IPv4RouterIDRemoteNodeLATLV != null : !this.IPv4RouterIDRemoteNodeLATLV.equals(other.IPv4RouterIDRemoteNodeLATLV)) {
            return false;
        }
        if (this.OSPFForwardingAddrTLV == null ? other.OSPFForwardingAddrTLV != null : !this.OSPFForwardingAddrTLV.equals(other.OSPFForwardingAddrTLV)) {
            return false;
        }
        if (this.SharedRiskLinkGroupATLV == null ? other.SharedRiskLinkGroupATLV != null : !this.SharedRiskLinkGroupATLV.equals(other.SharedRiskLinkGroupATLV)) {
            return false;
        }
        if (this.TEMetricTLV == null ? other.TEMetricTLV != null : !this.TEMetricTLV.equals(other.TEMetricTLV)) {
            return false;
        }
        if (this.TransceiverClassAndAppATLV == null ? other.TransceiverClassAndAppATLV != null : !this.TransceiverClassAndAppATLV.equals(other.TransceiverClassAndAppATLV)) {
            return false;
        }
        if (this.administrativeGroupTLV == null ? other.administrativeGroupTLV != null : !this.administrativeGroupTLV.equals(other.administrativeGroupTLV)) {
            return false;
        }
        if (this.areaIDTLV == null ? other.areaIDTLV != null : !this.areaIDTLV.equals(other.areaIDTLV)) {
            return false;
        }
        if (this.igpFlagBitsTLV == null ? other.igpFlagBitsTLV != null : !this.igpFlagBitsTLV.equals(other.igpFlagBitsTLV)) {
            return false;
        }
        if (this.linkProtectionTLV == null ? other.linkProtectionTLV != null : !this.linkProtectionTLV.equals(other.linkProtectionTLV)) {
            return false;
        }
        if (this.maxReservableBandwidthTLV == null ? other.maxReservableBandwidthTLV != null : !this.maxReservableBandwidthTLV.equals(other.maxReservableBandwidthTLV)) {
            return false;
        }
        if (this.maximumLinkBandwidthTLV == null ? other.maximumLinkBandwidthTLV != null : !this.maximumLinkBandwidthTLV.equals(other.maximumLinkBandwidthTLV)) {
            return false;
        }
        if (this.metricTLV == null ? other.metricTLV != null : !this.metricTLV.equals(other.metricTLV)) {
            return false;
        }
        if (this.nodeFlagBitsTLV == null ? other.nodeFlagBitsTLV != null : !this.nodeFlagBitsTLV.equals(other.nodeFlagBitsTLV)) {
            return false;
        }
        if (this.nodeNameTLV == null ? other.nodeNameTLV != null : !this.nodeNameTLV.equals(other.nodeNameTLV)) {
            return false;
        }
        if (this.prefixMetricTLV == null ? other.prefixMetricTLV != null : !this.prefixMetricTLV.equals(other.prefixMetricTLV)) {
            return false;
        }
        if (this.routeTagTLV == null ? other.routeTagTLV != null : !this.routeTagTLV.equals(other.routeTagTLV)) {
            return false;
        }
        if (this.sidLabelTLV == null ? other.sidLabelTLV != null : !this.sidLabelTLV.equals(other.sidLabelTLV)) {
            return false;
        }
        return !(this.unreservedBandwidthTLV == null ? other.unreservedBandwidthTLV != null : !this.unreservedBandwidthTLV.equals(other.unreservedBandwidthTLV));
    }
}

