/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields.pathAttributes;

import es.tid.bgp.bgp4.update.fields.IPv4PrefixNLRI;
import es.tid.bgp.bgp4.update.fields.ITNodeNLRI;
import es.tid.bgp.bgp4.update.fields.LinkNLRI;
import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;
import es.tid.bgp.bgp4.update.fields.NodeNLRI;
import es.tid.bgp.bgp4.update.fields.pathAttributes.MP_Reach_Attribute;
import java.util.LinkedList;
import java.util.List;

public class BGP_LS_MP_Reach_Attribute
extends MP_Reach_Attribute {
    private LinkStateNLRI lsNLRI;
    private List<LinkStateNLRI> lsNLRIList;

    public BGP_LS_MP_Reach_Attribute() {
        this.setAddressFamilyIdentifier(16388);
        this.setSubsequentAddressFamilyIdentifier(71);
        this.lsNLRIList = new LinkedList<LinkStateNLRI>();
    }

    public BGP_LS_MP_Reach_Attribute(byte[] bytes, int offset) {
        super(bytes, offset);
        int offset2 = offset + this.mandatoryLength + 5 + this.getLengthofNextHopNetworkAddress();
        this.lsNLRIList = new LinkedList<LinkStateNLRI>();
        while (offset2 < this.length + offset) {
            LinkStateNLRI tempNLri;
            int type = LinkStateNLRI.getType(bytes, offset2);
            if (type == 2) {
                tempNLri = new LinkNLRI(bytes, offset2);
            } else if (type == 1) {
                tempNLri = new NodeNLRI(bytes, offset2);
            } else if (type == 5) {
                tempNLri = new ITNodeNLRI(bytes, offset2);
            } else if (type == 3) {
                tempNLri = new IPv4PrefixNLRI(bytes, offset2);
            } else {
                log.debug("UNKNOWN_NLRI: " + type);
                continue;
            }
            offset2 += tempNLri.getTotalNLRILength();
            this.lsNLRIList.add(tempNLri);
        }
        this.lsNLRI = this.lsNLRIList.isEmpty() ? null : this.lsNLRIList.get(0);
    }

    @Override
    public void encode() {
        this.pathAttributeLength = 5 + this.getLengthofNextHopNetworkAddress();
        int i = 0;
        while (i < this.lsNLRIList.size()) {
            this.lsNLRIList.get(i).encode();
            this.pathAttributeLength += this.lsNLRIList.get(i).getTotalNLRILength();
            ++i;
        }
        this.setPathAttributeLength(this.pathAttributeLength);
        this.bytes = new byte[this.getLength()];
        this.encodeHeader();
        this.encodeMP_Reach_Header();
        int offset = this.getMandatoryLength() + 5 + this.getLengthofNextHopNetworkAddress();
        int i2 = 0;
        while (i2 < this.lsNLRIList.size()) {
            System.arraycopy(this.lsNLRIList.get(i2).getBytes(), 0, this.bytes, offset, this.lsNLRIList.get(i2).getTotalNLRILength());
            offset += this.lsNLRIList.get(i2).getTotalNLRILength();
            ++i2;
        }
    }

    public LinkStateNLRI getLsNLRI() {
        return this.lsNLRI;
    }

    public List<LinkStateNLRI> getLsNLRIList() {
        return this.lsNLRIList;
    }

    public void setLsNLRI(LinkStateNLRI lsNLRI) {
        this.lsNLRI = lsNLRI;
        if (this.lsNLRIList.size() > 0) {
            this.lsNLRIList = new LinkedList<LinkStateNLRI>();
        }
        this.lsNLRIList.add(lsNLRI);
    }

    public void setLsNLRIList(List<LinkStateNLRI> lsNLRIList) {
        this.lsNLRIList = lsNLRIList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[BGP_LS_MP_REACH ");
        for (LinkStateNLRI ls : this.lsNLRIList) {
            sb.append(ls.toString() + " ");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        for (LinkStateNLRI ls : this.lsNLRIList) {
            result = 31 * result + this.lsNLRI.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BGP_LS_MP_Reach_Attribute other = (BGP_LS_MP_Reach_Attribute)obj;
        if (this.lsNLRIList.size() != other.getLsNLRIList().size()) {
            return false;
        }
        List<LinkStateNLRI> otherlsNLRIList = other.getLsNLRIList();
        return this.lsNLRIList.equals(otherlsNLRIList);
    }
}

