/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields.pathAttributes;

import es.tid.bgp.bgp4.update.MalformedBGP4ElementException;
import es.tid.bgp.bgp4.update.fields.PathAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Segment;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AS_Path_Attribute
extends PathAttribute {
    private LinkedList<AS_Path_Segment> asPathSegments;

    public AS_Path_Attribute() {
        this.typeCode = 2;
        this.asPathSegments = new LinkedList();
    }

    public AS_Path_Attribute(byte[] bytes, int offset) throws MalformedBGP4ElementException {
        super(bytes, offset);
        this.asPathSegments = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int path_attribute_length = 0;
        for (AS_Path_Segment asPathSegment : this.asPathSegments) {
            asPathSegment.encode();
            path_attribute_length += asPathSegment.getLength();
        }
        this.setPathAttributeLength(path_attribute_length);
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int offset = this.mandatoryLength;
        int num_segs = this.asPathSegments.size();
        int i = 0;
        while (i < num_segs) {
            System.arraycopy(this.asPathSegments.get(i).getBytes(), 0, this.bytes, offset, this.asPathSegments.get(i).getLength());
            offset += this.asPathSegments.get(i).getLength();
            ++i;
        }
    }

    public void decode() throws MalformedBGP4ElementException {
        if (this.typeCode != 2) {
            throw new MalformedBGP4ElementException();
        }
        int offset = this.mandatoryLength;
        while (offset < this.length) {
            AS_Path_Segment asPathSegment = new AS_Path_Segment(this.bytes, offset);
            this.asPathSegments.add(asPathSegment);
            offset += asPathSegment.getLength();
        }
    }

    public int getType() {
        return this.typeCode;
    }

    public List<AS_Path_Segment> getAsPathSegments() {
        return this.asPathSegments;
    }

    public void setAsPathSegments(LinkedList<AS_Path_Segment> asPathSegments) {
        this.asPathSegments = asPathSegments;
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "AS_PATH [Type=" + this.typeCode + " Length=" + this.length + " NumberOfAsPathSegments=" + this.asPathSegments.size() + "]";
        int i = 0;
        while (i < this.asPathSegments.size()) {
            ret = (String)ret + this.asPathSegments.toString();
            ++i;
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AS_Path_Attribute other = (AS_Path_Attribute)obj;
        if (!Arrays.equals(this.bytes, other.getBytes())) {
            return false;
        }
        return this.length == other.getLength();
    }
}

