/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.objects.BGP4Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathAttribute
extends BGP4Object {
    protected static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");
    protected int typeCode;
    protected boolean optionalBit = false;
    protected boolean transitiveBit = true;
    protected boolean partialBit = false;
    protected boolean extendedLengthBit = false;
    protected int mandatoryLength = 3;
    protected int pathAttributeLength;

    public PathAttribute() {
    }

    public PathAttribute(byte[] bytes, int offset) {
        this.optionalBit = (bytes[offset] & 0x80) == 128;
        this.transitiveBit = (bytes[offset] & 0x40) == 64;
        this.partialBit = (bytes[offset] & 0x20) == 32;
        this.extendedLengthBit = (bytes[offset] & 0x10) == 16;
        this.typeCode = bytes[offset + 1] & 0xFF;
        if (this.extendedLengthBit) {
            this.mandatoryLength = 4;
            this.pathAttributeLength = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        } else {
            this.pathAttributeLength = bytes[offset + 2] & 0xFF;
        }
        this.length = this.pathAttributeLength + this.mandatoryLength;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
    }

    public void encodeHeader() {
        this.bytes[0] = 0;
        this.bytes[0] = (byte)((this.optionalBit ? 1 : 0) << 7 & 0x80 | (this.transitiveBit ? 1 : 0) << 6 & 0x40 | (this.partialBit ? 1 : 0) << 5 & 0x20 | (this.extendedLengthBit ? 1 : 0) << 4 & 0x10);
        this.bytes[1] = (byte)(this.typeCode & 0xFF);
        if (this.extendedLengthBit) {
            this.bytes[2] = (byte)(this.pathAttributeLength >>> 8 & 0xFF);
            this.bytes[3] = (byte)(this.pathAttributeLength & 0xFF);
            this.mandatoryLength = 4;
        } else {
            this.bytes[2] = (byte)(this.pathAttributeLength & 0xFF);
        }
    }

    protected void setPathAttributeLength(int pal) {
        this.pathAttributeLength = pal;
        if (this.pathAttributeLength > 255) {
            this.mandatoryLength = 4;
            this.length = this.pathAttributeLength + this.mandatoryLength;
        } else {
            this.mandatoryLength = 3;
            this.length = this.pathAttributeLength + this.mandatoryLength;
        }
    }

    public int getPathAttributeLength() {
        return this.pathAttributeLength;
    }

    public int getMandatoryLength() {
        return this.mandatoryLength;
    }

    public static int getAttibuteTypeCode(byte[] bytes, int offset) {
        try {
            int obc = bytes[offset + 1] & 0xFF;
            return obc;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static int getMandatoryLength(byte[] bytes, int offset) {
        boolean extendedLengthBit;
        boolean bl = extendedLengthBit = (bytes[offset] & 0x10) == 16;
        if (extendedLengthBit) {
            return 4;
        }
        return 3;
    }

    public static int getAttributeLength(byte[] bytes, int offset) {
        boolean extendedLengthBit;
        boolean bl = extendedLengthBit = (bytes[offset] & 0x10) == 16;
        if (extendedLengthBit) {
            return (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        }
        return bytes[offset + 2] & 0xFF;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    protected void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extendedLengthBit ? 1231 : 1237);
        result = 31 * result + this.mandatoryLength;
        result = 31 * result + (this.optionalBit ? 1231 : 1237);
        result = 31 * result + (this.partialBit ? 1231 : 1237);
        result = 31 * result + this.pathAttributeLength;
        result = 31 * result + (this.transitiveBit ? 1231 : 1237);
        result = 31 * result + this.typeCode;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathAttribute other = (PathAttribute)obj;
        if (this.extendedLengthBit != other.extendedLengthBit) {
            return false;
        }
        if (this.mandatoryLength != other.mandatoryLength) {
            return false;
        }
        if (this.optionalBit != other.optionalBit) {
            return false;
        }
        if (this.partialBit != other.partialBit) {
            return false;
        }
        if (this.pathAttributeLength != other.pathAttributeLength) {
            return false;
        }
        if (this.transitiveBit != other.transitiveBit) {
            return false;
        }
        return this.typeCode == other.typeCode;
    }
}

