/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;
import es.tid.bgp.bgp4.update.tlv.LocalNodeDescriptorsTLV;

public class NodeNLRI
extends LinkStateNLRI {
    private int protocolID;
    private long routingUniverseIdentifier;
    private LocalNodeDescriptorsTLV localNodeDescriptors;

    public NodeNLRI() {
        this.setNLRIType(1);
        this.setRoutingUniverseIdentifier(0L);
    }

    public NodeNLRI(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 13;
        if (this.localNodeDescriptors != null) {
            this.localNodeDescriptors.encode();
            len += this.localNodeDescriptors.getTotalTLVLength();
        }
        this.setTotalNLRILength(len);
        this.setLength(len);
        this.bytes = new byte[len];
        this.encodeHeader();
        this.bytes[4] = (byte)this.protocolID;
        this.bytes[5] = (byte)(this.routingUniverseIdentifier >>> 56 & 0xFFL);
        this.bytes[6] = (byte)(this.routingUniverseIdentifier >>> 48 & 0xFFL);
        this.bytes[7] = (byte)(this.routingUniverseIdentifier >>> 40 & 0xFFL);
        this.bytes[8] = (byte)(this.routingUniverseIdentifier >>> 32 & 0xFFL);
        this.bytes[9] = (byte)(this.routingUniverseIdentifier >>> 24 & 0xFFL);
        this.bytes[10] = (byte)(this.routingUniverseIdentifier >>> 16 & 0xFFL);
        this.bytes[11] = (byte)(this.routingUniverseIdentifier >>> 8 & 0xFFL);
        this.bytes[12] = (byte)(this.routingUniverseIdentifier & 0xFFL);
        int offset = 13;
        if (this.localNodeDescriptors != null) {
            System.arraycopy(this.localNodeDescriptors.getTlv_bytes(), 0, this.bytes, offset, this.localNodeDescriptors.getTotalTLVLength());
            offset += this.localNodeDescriptors.getTotalTLVLength();
        }
    }

    public void decode() {
        int offset = 4;
        this.protocolID = this.bytes[offset];
        byte[] ip = new byte[8];
        System.arraycopy(this.bytes, ++offset, ip, 0, 8);
        long routingUniverseIdentifieraux1 = ((long)this.bytes[offset] & 0xFFL) << 24 & 0xFFFFFFFFFF000000L | (long)this.bytes[offset + 1] << 16 & 0xFF0000L | (long)this.bytes[offset + 2] << 8 & 0xFF00L | (long)this.bytes[offset + 3] & 0xFFL;
        long routingUniverseIdentifieraux2 = ((long)this.bytes[offset + 4] & 0xFFL) << 24 & 0xFFFFFFFFFF000000L | (long)this.bytes[offset + 5] << 16 & 0xFF0000L | (long)this.bytes[offset + 6] << 8 & 0xFF00L | (long)this.bytes[offset + 7] & 0xFFL;
        this.setRoutingUniverseIdentifier(routingUniverseIdentifieraux1 << 32 & 0xFFFFFFFF00000000L | routingUniverseIdentifieraux2);
        this.localNodeDescriptors = new LocalNodeDescriptorsTLV(this.bytes, offset += 8);
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public void setProtocolID(int protocolID) {
        this.protocolID = protocolID;
    }

    public LocalNodeDescriptorsTLV getLocalNodeDescriptors() {
        return this.localNodeDescriptors;
    }

    public void setLocalNodeDescriptors(LocalNodeDescriptorsTLV localNodeDescriptors) {
        this.localNodeDescriptors = localNodeDescriptors;
    }

    public String toString() {
        return "NodeNLRI [protocolID=" + this.protocolID + ", routingUniverseIdentifier=" + this.routingUniverseIdentifier + ", localNodeDescriptors=" + this.localNodeDescriptors.toString() + "]";
    }

    public long getRoutingUniverseIdentifier() {
        return this.routingUniverseIdentifier;
    }

    public void setRoutingUniverseIdentifier(long routingUniverseIdentifier) {
        this.routingUniverseIdentifier = routingUniverseIdentifier;
    }
}

