/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.update.fields.NLRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinkStateNLRI
extends NLRI {
    protected int NLRIType;
    protected int TotalNLRILength;
    protected static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public LinkStateNLRI() {
    }

    public LinkStateNLRI(byte[] bytes, int offset) {
        this.NLRIType = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        int valueNLRILength = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        this.TotalNLRILength = valueNLRILength + 4;
        this.bytes = new byte[this.TotalNLRILength];
        this.length = this.TotalNLRILength;
        System.arraycopy(bytes, offset, this.bytes, 0, this.TotalNLRILength);
    }

    protected void encodeHeader() {
        int nlriValueLength = this.TotalNLRILength - 4;
        this.bytes[0] = (byte)(this.NLRIType >>> 8 & 0xFF);
        this.bytes[1] = (byte)(this.NLRIType & 0xFF);
        this.bytes[2] = (byte)(nlriValueLength >>> 8 & 0xFF);
        this.bytes[3] = (byte)(nlriValueLength & 0xFF);
    }

    public static int getTotalTLVLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | (bytes[offset + 3] & 0xFF) + 4;
        if (len % 4 != 0) {
            len = len + 4 - len % 4;
        }
        return len;
    }

    public static int getNLRILength(byte[] bytes, int offset) {
        int len = (bytes[offset + 2] & 0xFF) << 8 & 0xFF00 | bytes[offset + 3] & 0xFF;
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
        return typ;
    }

    public int getNLRIType() {
        return this.NLRIType;
    }

    protected void setNLRIType(int nLRIType) {
        this.NLRIType = nLRIType;
    }

    public int getTotalNLRILength() {
        return this.TotalNLRILength;
    }

    protected void setTotalNLRILength(int totalNLRILength) {
        this.TotalNLRILength = totalNLRILength;
    }

    public static int getNLRIType(byte[] bytes, int offset) {
        try {
            int obc = (bytes[offset] & 0xFF) << 8 & 0xFF00 | bytes[offset + 1] & 0xFF;
            return obc;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    @Override
    public abstract void encode();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.NLRIType;
        result = 31 * result + this.TotalNLRILength;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkStateNLRI other = (LinkStateNLRI)obj;
        if (this.NLRIType != other.NLRIType) {
            return false;
        }
        return this.TotalNLRILength == other.TotalNLRILength;
    }
}

