/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.update.fields;

import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;

public class ITNodeNLRI
extends LinkStateNLRI {
    private String nodeId;
    private String controllerIT;
    private String cpu;
    private String mem;
    private String storage;

    public ITNodeNLRI() {
        this.setNLRIType(5);
    }

    public ITNodeNLRI(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        byte[] bytesStringNodeId = this.nodeId.getBytes();
        len = len + 4 + bytesStringNodeId.length;
        byte[] bytesStringControllerIT = this.controllerIT.getBytes();
        len = len + 4 + bytesStringControllerIT.length;
        byte[] bytesStringCpu = this.cpu.getBytes();
        len += 4 + bytesStringCpu.length;
        byte[] bytesStringMem = this.mem.getBytes();
        len += 4 + bytesStringMem.length;
        byte[] bytesStringStorage = this.storage.getBytes();
        this.setTotalNLRILength(len += 4 + bytesStringStorage.length);
        this.setLength(len);
        this.bytes = new byte[len];
        this.encodeHeader();
        int offset = 4;
        offset = this.encodeHeaderSubTLV(1, bytesStringNodeId.length, offset);
        int i = 0;
        while (i < bytesStringNodeId.length) {
            this.bytes[offset] = bytesStringNodeId[i];
            ++offset;
            ++i;
        }
        offset = this.encodeHeaderSubTLV(2, bytesStringControllerIT.length, offset);
        i = 0;
        while (i < bytesStringControllerIT.length) {
            this.bytes[offset] = bytesStringControllerIT[i];
            ++offset;
            ++i;
        }
        offset = this.encodeHeaderSubTLV(3, bytesStringCpu.length, offset);
        i = 0;
        while (i < bytesStringCpu.length) {
            this.bytes[offset] = bytesStringCpu[i];
            ++offset;
            ++i;
        }
        offset = this.encodeHeaderSubTLV(4, bytesStringMem.length, offset);
        i = 0;
        while (i < bytesStringMem.length) {
            this.bytes[offset] = bytesStringMem[i];
            ++offset;
            ++i;
        }
        offset = this.encodeHeaderSubTLV(5, bytesStringStorage.length, offset);
        i = 0;
        while (i < bytesStringStorage.length) {
            this.bytes[offset] = bytesStringStorage[i];
            ++offset;
            ++i;
        }
    }

    public void decode() {
        int offset = 2;
        byte[] lengthITNodeNLRIBytes = new byte[2];
        System.arraycopy(this.bytes, offset, lengthITNodeNLRIBytes, 0, 2);
        int lengthITNodeNLRI = lengthITNodeNLRIBytes[0] << 8 & 0xFF00 | lengthITNodeNLRIBytes[1] & 0xFF;
        offset += 2;
        int lengthResourcesgeted = 0;
        while (lengthResourcesgeted < lengthITNodeNLRI) {
            byte[] typeResourceBytes = new byte[2];
            System.arraycopy(this.bytes, offset, typeResourceBytes, 0, 2);
            int typeResource = typeResourceBytes[0] << 8 & 0xFF00 | typeResourceBytes[1] & 0xFF;
            byte[] lengthResourceBytes = new byte[2];
            System.arraycopy(this.bytes, offset += 2, lengthResourceBytes, 0, 2);
            int lengthResource = lengthResourceBytes[0] << 8 & 0xFF00 | lengthResourceBytes[1] & 0xFF;
            byte[] valueResourceBytes = new byte[lengthResource];
            System.arraycopy(this.bytes, offset += 2, valueResourceBytes, 0, lengthResource);
            String valueResource = new String(valueResourceBytes);
            offset += lengthResource;
            switch (typeResource) {
                case 1: {
                    this.nodeId = valueResource;
                    break;
                }
                case 2: {
                    this.controllerIT = valueResource;
                    break;
                }
                case 3: {
                    this.cpu = valueResource;
                    break;
                }
                case 4: {
                    this.mem = valueResource;
                    break;
                }
                case 5: {
                    this.storage = valueResource;
                }
            }
            lengthResourcesgeted += 4 + lengthResource;
        }
    }

    protected int encodeHeaderSubTLV(int type, int valueLength, int byteStart) {
        this.bytes[byteStart] = (byte)(type >>> 8 & 0xFF);
        this.bytes[byteStart + 1] = (byte)(type & 0xFF);
        this.bytes[byteStart + 2] = (byte)(valueLength >>> 8 & 0xFF);
        this.bytes[byteStart + 3] = (byte)(valueLength & 0xFF);
        return byteStart + 4;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getMem() {
        return this.mem;
    }

    public void setMem(String mem) {
        this.mem = mem;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public String toString() {
        return "ITNodeNLRI [nodeID=" + this.nodeId + "controllerIT=" + this.controllerIT + ", cpu=" + this.cpu + ", mem=" + this.mem + ", storage=" + this.storage + "]";
    }

    public String getControllerIT() {
        return this.controllerIT;
    }

    public void setControllerIT(String controllerIT) {
        this.controllerIT = controllerIT;
    }
}

