/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.open;

import es.tid.bgp.bgp4.open.BGP4Capability;

public class MultiprotocolExtensionCapabilityAdvertisement
extends BGP4Capability {
    int AFI;
    int SAFI;

    public MultiprotocolExtensionCapabilityAdvertisement() {
        this.setCapabitityCode(1);
    }

    public MultiprotocolExtensionCapabilityAdvertisement(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setCapabilityLength(4);
        this.bytes = new byte[this.getLength()];
        this.encodeHeader();
        int offset = 2;
        this.bytes[offset] = (byte)(this.AFI >>> 8 & 0xFF);
        this.bytes[offset + 1] = (byte)(this.AFI & 0xFF);
        this.bytes[offset + 3] = (byte)(this.SAFI & 0xFF);
    }

    public void decode() {
        int offset = 2;
        this.AFI = (this.bytes[offset] & 0xFF) << 8 & 0xFF00 | this.bytes[offset + 1] & 0xFF;
        this.SAFI = this.bytes[offset + 3] & 0xFF;
    }

    public int getAFI() {
        return this.AFI;
    }

    public void setAFI(int aFI) {
        this.AFI = aFI;
    }

    public int getSAFI() {
        return this.SAFI;
    }

    public void setSAFI(int sAFI) {
        this.SAFI = sAFI;
    }

    public String toString() {
        return "MultiprotocolExtensionCapabilityAdvertisement [AFI=" + this.AFI + ", SAFI=" + this.SAFI + "]";
    }
}

