/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.open;

import es.tid.bgp.bgp4.objects.BGP4Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BGP4OptionalParameter
extends BGP4Object {
    protected int type;
    protected int parameterLength;
    private static Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public BGP4OptionalParameter() {
    }

    public BGP4OptionalParameter(byte[] bytes, int offset) {
        this.type = bytes[offset] & 0xFF;
        this.parameterLength = bytes[offset + 1] & 0xFF;
        this.length = this.parameterLength + 2;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
    }

    protected void encodeOptionalParameterHeader() {
        this.bytes[0] = (byte)(this.type & 0xFF);
        this.bytes[1] = (byte)(this.parameterLength & 0xFF);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static int getParameterLength(byte[] bytes, int offset) {
        int len = bytes[offset + 1] & 0xFF;
        return len;
    }

    public static int getLength(byte[] bytes, int offset) {
        int len = (bytes[offset + 1] & 0xFF) + 2;
        return len;
    }

    public static int getType(byte[] bytes, int offset) {
        int typ = bytes[offset] & 0xFF;
        return typ;
    }

    public int getParameterLength() {
        return this.parameterLength;
    }

    public void setParameterLength(int parameterLength) {
        this.parameterLength = parameterLength;
    }
}

