/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.open;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BGP4Capability {
    private int capabitityCode;
    private int capabilityLength;
    private int length;
    protected byte[] bytes;
    protected static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public BGP4Capability() {
    }

    public BGP4Capability(byte[] bytes, int offset) {
        this.capabitityCode = bytes[offset] & 0xFF;
        this.capabilityLength = bytes[offset + 1] & 0xFF;
        this.length = this.capabilityLength + 2;
        this.bytes = new byte[this.length];
        System.arraycopy(bytes, offset, this.bytes, 0, this.length);
    }

    public void encodeHeader() {
        this.bytes[0] = (byte)(this.capabitityCode & 0xFF);
        this.bytes[1] = (byte)(this.capabilityLength & 0xFF);
    }

    public abstract void encode();

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getCapabitityCode() {
        return this.capabitityCode;
    }

    public void setCapabitityCode(int capabitityCode) {
        this.capabitityCode = capabitityCode;
    }

    public int getCapabilityLength() {
        return this.capabilityLength;
    }

    public void setCapabilityLength(int capabilityLength) {
        this.capabilityLength = capabilityLength;
        this.length = this.capabilityLength + 2;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public static int getCapalitityCode(byte[] bytes, int offset) {
        int len = bytes[offset] & 0xFF;
        return len;
    }

    public static int getCapabilityLength(byte[] bytes, int offset) {
        int len = bytes[offset + 1] & 0xFF;
        return len;
    }
}

