/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.open;

import es.tid.bgp.bgp4.open.BGP4Capability;
import es.tid.bgp.bgp4.open.BGP4OctetsASByteCapabilityAdvertisement;
import es.tid.bgp.bgp4.open.BGP4OptionalParameter;
import es.tid.bgp.bgp4.open.MultiprotocolExtensionCapabilityAdvertisement;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BGP4CapabilitiesOptionalParameter
extends BGP4OptionalParameter {
    LinkedList<BGP4Capability> capabilityList;
    private static Logger log = LoggerFactory.getLogger((String)"BGP4Parser");

    public BGP4CapabilitiesOptionalParameter() {
        this.type = 2;
        this.capabilityList = new LinkedList();
    }

    public BGP4CapabilitiesOptionalParameter(byte[] bytes, int offset) {
        super(bytes, offset);
        this.capabilityList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        this.parameterLength = 0;
        int k = 0;
        while (k < this.capabilityList.size()) {
            this.capabilityList.get(k).encode();
            this.parameterLength += this.capabilityList.get(k).getLength();
            ++k;
        }
        this.length = this.parameterLength + 2;
        this.bytes = new byte[this.length];
        this.encodeOptionalParameterHeader();
        int offset = 2;
        int k2 = 0;
        while (k2 < this.capabilityList.size()) {
            System.arraycopy(this.capabilityList.get(k2).getBytes(), 0, this.bytes, offset, this.capabilityList.get(k2).getLength());
            offset += this.capabilityList.get(k2).getLength();
            ++k2;
        }
    }

    public void decode() {
        int offset = 2;
        while (offset < this.getLength()) {
            BGP4Capability meca;
            int capabilityCode = BGP4Capability.getCapalitityCode(this.bytes, offset);
            log.debug("Capability code " + capabilityCode);
            if (capabilityCode == 1) {
                meca = new MultiprotocolExtensionCapabilityAdvertisement(this.bytes, offset);
                this.capabilityList.add(meca);
                offset += meca.getLength();
                continue;
            }
            if (capabilityCode == 65) {
                meca = new BGP4OctetsASByteCapabilityAdvertisement(this.bytes, offset);
                this.capabilityList.add(meca);
                offset += meca.getLength();
                continue;
            }
            log.debug("Unknown capability " + BGP4Capability.getCapabilityLength(this.bytes, offset));
            offset = offset + BGP4Capability.getCapabilityLength(this.bytes, offset) + 2;
        }
    }

    public LinkedList<BGP4Capability> getCapabilityList() {
        return this.capabilityList;
    }

    public void setCapabilityList(LinkedList<BGP4Capability> capabilityList) {
        this.capabilityList = capabilityList;
    }
}

