/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.messages;

import es.tid.bgp.bgp4.messages.BGP4Message;
import es.tid.bgp.bgp4.update.fields.ITNodeNLRI;
import es.tid.bgp.bgp4.update.fields.LinkNLRI;
import es.tid.bgp.bgp4.update.fields.LinkStateNLRI;
import es.tid.bgp.bgp4.update.fields.NLRI;
import es.tid.bgp.bgp4.update.fields.NodeNLRI;
import es.tid.bgp.bgp4.update.fields.PathAttribute;
import es.tid.bgp.bgp4.update.fields.WithdrawnRoutes;
import es.tid.bgp.bgp4.update.fields.pathAttributes.AS_Path_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.BGP_LS_MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.Generic_MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.Generic_MP_Unreach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.LinkStateAttribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.MP_Reach_Attribute;
import es.tid.bgp.bgp4.update.fields.pathAttributes.OriginAttribute;
import java.util.ArrayList;

public class BGP4Update
extends BGP4Message {
    private String learntFrom;
    private WithdrawnRoutes withdrawnRoutes;
    private ArrayList<PathAttribute> pathAttributes;
    private NLRI nlri;

    public BGP4Update() {
        this.setMessageType(2);
        this.pathAttributes = new ArrayList();
    }

    public BGP4Update(byte[] bytes) {
        super(bytes);
        this.messageBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.messageBytes, 0, bytes.length);
        this.decode();
    }

    @Override
    public void encode() {
        if (this.withdrawnRoutes == null && this.pathAttributes.size() == 0) {
            log.warn("There should be withdrawnRoutes or path Attributes");
        }
        int withdrawnRoutesLength = 0;
        if (this.withdrawnRoutes == null) {
            withdrawnRoutesLength = 0;
        }
        int len = BGPHeaderLength;
        len += 4;
        if (this.withdrawnRoutes != null) {
            this.withdrawnRoutes.encode();
            len += this.withdrawnRoutes.getLength();
            withdrawnRoutesLength = this.withdrawnRoutes.getLength();
        }
        int totalPathAttibuteLength = 0;
        int i = 0;
        while (i < this.pathAttributes.size()) {
            this.pathAttributes.get(i).encode();
            len += this.pathAttributes.get(i).getLength();
            totalPathAttibuteLength += this.pathAttributes.get(i).getLength();
            ++i;
        }
        if (this.nlri != null) {
            this.nlri.encode();
            len += this.nlri.getLength();
        }
        this.setMessageLength(len);
        this.messageBytes = new byte[len];
        this.encodeHeader();
        int offset = BGPHeaderLength;
        this.messageBytes[offset] = (byte)(withdrawnRoutesLength >>> 8 & 0xFF);
        this.messageBytes[offset + 1] = (byte)(withdrawnRoutesLength & 0xFF);
        offset += 2;
        if (this.withdrawnRoutes != null) {
            System.arraycopy(this.withdrawnRoutes.getBytes(), 0, this.messageBytes, offset, this.withdrawnRoutes.getLength());
            offset += this.withdrawnRoutes.getLength();
        }
        this.messageBytes[offset] = (byte)(totalPathAttibuteLength >>> 8 & 0xFF);
        this.messageBytes[offset + 1] = (byte)(totalPathAttibuteLength & 0xFF);
        offset += 2;
        int i2 = 0;
        while (i2 < this.pathAttributes.size()) {
            System.arraycopy(this.pathAttributes.get(i2).getBytes(), 0, this.messageBytes, offset, this.pathAttributes.get(i2).getLength());
            offset += this.pathAttributes.get(i2).getLength();
            ++i2;
        }
        if (this.nlri != null) {
            System.arraycopy(this.nlri.getBytes(), 0, this.messageBytes, offset, this.nlri.getBytes().length);
            offset += this.nlri.getLength();
        }
    }

    public void decode() {
        int offset = BGPHeaderLength;
        int withdrawnRoutesLength = this.messageBytes[offset] << 8 & 0xFF00 | this.messageBytes[offset + 1] & 0xFF;
        offset += 2;
        if (withdrawnRoutesLength != 0) {
            log.warn("withdrawnRoutesLength not implemented");
            offset += withdrawnRoutesLength;
        } else {
            this.withdrawnRoutes = null;
        }
        int totalPathAttibuteLength = this.messageBytes[offset] << 8 & 0xFF00 | this.messageBytes[offset + 1] & 0xFF;
        offset += 2;
        if (totalPathAttibuteLength != 0) {
            this.pathAttributes = new ArrayList();
            int len = 0;
            while (len < totalPathAttibuteLength) {
                int attribute_typeCode = PathAttribute.getAttibuteTypeCode(this.messageBytes, offset);
                int attribute_length = PathAttribute.getAttributeLength(this.messageBytes, offset);
                int mandatory_length = PathAttribute.getMandatoryLength(this.messageBytes, offset);
                if (attribute_typeCode == 1) {
                    OriginAttribute origin = new OriginAttribute(this.messageBytes, offset);
                    this.pathAttributes.add(origin);
                } else if (attribute_typeCode == 2) {
                    AS_Path_Attribute as_Path_Attribute = new AS_Path_Attribute(this.messageBytes, offset);
                    this.pathAttributes.add(as_Path_Attribute);
                } else if (attribute_typeCode == 29 || attribute_typeCode == 99) {
                    LinkStateAttribute linkState_Attribute = new LinkStateAttribute(this.messageBytes, offset);
                    this.pathAttributes.add(linkState_Attribute);
                } else if (attribute_typeCode == 14) {
                    int afi = MP_Reach_Attribute.getAFI(this.messageBytes, offset);
                    if (afi == 16388) {
                        BGP_LS_MP_Reach_Attribute blsra = new BGP_LS_MP_Reach_Attribute(this.messageBytes, offset);
                        this.pathAttributes.add(blsra);
                    } else {
                        Generic_MP_Reach_Attribute gblsra = new Generic_MP_Reach_Attribute(this.messageBytes, offset);
                        this.pathAttributes.add(gblsra);
                    }
                } else if (attribute_typeCode == 15) {
                    Generic_MP_Unreach_Attribute mpUnreachAttribute = new Generic_MP_Unreach_Attribute(this.messageBytes, offset);
                    this.pathAttributes.add(mpUnreachAttribute);
                } else {
                    log.warn("attribute_typeCode NOT supported by this implementation " + attribute_typeCode);
                }
                offset = offset + attribute_length + mandatory_length;
                len = len + attribute_length + mandatory_length;
            }
            if (offset >= this.getLength()) {
                return;
            }
            int nlri_type = LinkStateNLRI.getNLRIType(this.messageBytes, offset);
            if (nlri_type == 2) {
                this.nlri = new LinkNLRI(this.messageBytes, offset);
                offset += this.nlri.getLength();
            }
            if (nlri_type == 1) {
                this.nlri = new NodeNLRI(this.messageBytes, offset);
                offset += this.nlri.getLength();
            }
            if (nlri_type == 5) {
                this.nlri = new ITNodeNLRI(this.messageBytes, offset);
                offset += this.nlri.getLength();
            }
            if (this.nlri == null && withdrawnRoutesLength == 0) {
                log.warn("BGP4 Update without NRLI and without Withdrawn Routes");
            }
        }
    }

    public WithdrawnRoutes getWithdrawnRoutes() {
        return this.withdrawnRoutes;
    }

    public void setWithdrawnRoutes(WithdrawnRoutes withdrawnRoutes) {
    }

    public ArrayList<PathAttribute> getPathAttributes() {
        return this.pathAttributes;
    }

    public void setPathAttributes(ArrayList<PathAttribute> pathAttribute) {
        this.pathAttributes = pathAttribute;
    }

    public NLRI getNlri() {
        return this.nlri;
    }

    public void setNlri(NLRI nlri) {
        this.nlri = nlri;
    }

    public String getLearntFrom() {
        return this.learntFrom;
    }

    public void setLearntFrom(String learntFrom) {
        this.learntFrom = learntFrom;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80000);
        sb.append("BGP4Update Msg: ");
        if (this.pathAttributes.size() != 0) {
            sb.append("> Path Attibutes: \n");
            int i = 0;
            while (i < this.pathAttributes.size()) {
                if (i == 0) {
                    sb.append("> NLRI Type: " + this.pathAttributes.get(i).toString() + "\n");
                } else {
                    sb.append("> " + this.pathAttributes.get(i).toString() + "\n");
                }
                ++i;
            }
        }
        if (this.nlri != null) {
            sb.append(this.nlri.toString());
        }
        return sb.toString();
    }
}

