/*
 * Decompiled with CFR 0.152.
 */
package es.tid.bgp.bgp4.messages;

import es.tid.bgp.bgp4.BGP4Element;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BGP4Message
implements BGP4Element {
    protected byte[] messageBytes;
    private int messageType;
    private int messageLength;
    protected static final Logger log = LoggerFactory.getLogger((String)"BGP4Parser");
    public static int BGPHeaderLength = 19;
    public static int BGPMarkerLength = 16;

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public BGP4Message() {
    }

    public BGP4Message(byte[] bytes) {
        this.messageLength = (bytes[16] & 0xFF) * 256 + (bytes[17] & 0xFF);
        if (bytes.length != this.getLength()) {
            log.warn("Bytes and length in BGP header do not match");
        }
        this.messageBytes = new byte[this.messageLength];
        System.arraycopy(bytes, 0, this.messageBytes, 0, this.messageLength);
        this.messageType = this.messageBytes[18] & 0xFF;
    }

    @Override
    public byte[] getBytes() {
        return this.messageBytes;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public static int getMessageType(byte[] bytes) {
        byte mt = bytes[18];
        return mt;
    }

    @Override
    public int getLength() {
        return this.messageLength;
    }

    protected void encodeHeader() {
        int i = 0;
        while (i < 16) {
            this.messageBytes[i] = -1;
            ++i;
        }
        this.messageBytes[16] = (byte)(this.messageLength >> 8 & 0xFF);
        this.messageBytes[17] = (byte)(this.messageLength & 0xFF);
        this.messageBytes[18] = (byte)this.messageType;
    }

    public static int getBGPMarkerLength() {
        return BGPMarkerLength;
    }

    public static int getBGPHeaderLength() {
        return BGPHeaderLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.messageBytes);
        result = 31 * result + this.messageLength;
        result = 31 * result + this.messageType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BGP4Message other = (BGP4Message)obj;
        if (!Arrays.equals(this.messageBytes, other.messageBytes)) {
            return false;
        }
        if (this.messageLength != other.messageLength) {
            return false;
        }
        return this.messageType == other.messageType;
    }
}

