# Tests for P4 routing, ACL, and In-Band Network Telemetry functions

This directory contains the necessary scripts and configurations to run tests atop a Stratum-based P4 whitebox that performs a set of network functions, including routing, access control list (ACL), and In-Band Network Telemetry (INT).

## Prerequisites

You need Python3, which should already be installed while preparing for a TFS build.
Additionally, `pytest` is also mandatory as it is used by our tests below.
Aliasing python with python3 will also help bridging issues between older and newer python versions.

```shell
alias python='python3'
pip3 install pytest
pip3 install grpclib protobuf
pip3 install grpcio-tools
```

The versions used for this test are:
- `protobuf` 3.20.3
- `grpclib` 0.4.4
- `grpcio` 1.47.5
- `grpcio-tools` 1.47.5

After the installation of `grpclib`, protoc-gen-grpclib_python binary is in /home/$USER/.local/bin/
First we copy it to /usr/local/bin/:

```shell
  sudo cp /home/$USER/.local/bin/protoc-gen-grpclib_python /usr/local/bin/
```

Then, we include this path to the PYTHONPATH:
```shell
export PYTHONPATH="${PYTHONPATH}:/usr/local/bin/protoc-gen-grpclib_python"
```


You need to build and deploy a software-based Stratum switch, before being able to use TFS to control it.
To do so, follow the instructions in the `./topology` folder.

## Steps to setup and run a TFS program atop Stratum

To conduct this test, follow the steps below.

### TFS re-deploy

```shell
cd ~/tfs-ctrl/
source my_deploy.sh && source tfs_runtime_env_vars.sh
./deploy/all.sh
```

### Path setup

Ensure that `PATH` variable contains the parent project directory, e.g., "home/$USER/tfs-ctrl".

Ensure that `PYTHONPATH` variable contains the source code directory of TFS, e.g., "home/$USER/tfs-ctrl/src"

## Topology setup

In the `./topology/` directory there are scripts that allow to build Stratum on a target machine (e.g., a VM) and then deploy a P4 switch atop this machine.
This test assumes a Stratum P4 switch with 2 network interfaces used as a data plane (routing traffic from one to another) as well as another network interface used to send telemetry information to an external telemetry collector.

## P4 artifacts

In the `./p4src/` directory there are compiled P4 artifacts of the pipeline that will be pushed to the P4 switch, along with the P4-runtime definitions.
The `./setup.sh` script copies from this directory. If you need to change the P4 program, make sure to put the compiled artifacts there.

## Tests

The following tests are implemented.
For each of these tests, an auxiliary bash script allows to run it with less typing.

|                 Test                 |              Bash Runner           |                Purpose             |
| ------------------------------------ | ---------------------------------- | ---------------------------------- |
| -                                    | setup.sh                           | Copy P4 artifacts into the SBI pod |
| test_functional_bootstrap.py         | run_test_01_bootstrap.sh           | Connect TFS to the P4 switch       |
| test_functional_rules_provision.py   | run_test_02_rules_provision.sh     | Install rules on the P4 switch     |
| test_functional_rules_deprovision.py | run_test_03_rules_deprovision.sh   | Uninstall rules from the P4 switch |
| test_functional_cleanup.py           | run_test_04_cleanup.sh             | Disconnect TFS from the P4 switch  |

Each of the tests above is described in detail below.

### Step 1: Copy the necessary P4 artifacts into the TFS SBI service pod

The setup script copies the necessary artifacts to the SBI service pod.
It should be run just once, after a fresh install of TFS.
If you `deploy/all.sh` again, you need to repeat this step.

```shell
cd ~/tfs-ctrl/
source my_deploy.sh && source tfs_runtime_env_vars.sh
bash src/tests/p4-int-routing-acl/setup.sh
```

### Step 2: Bootstrap topology

The bootstrap script registers the context, topology, links, and devices to TFS.

```shell
cd ~/tfs-ctrl/
bash src/tests/p4-int-routing-acl/run_test_01_bootstrap.sh
```

### Step 3: Provision rules via the SBI API

Implement routing, ACL, and INT functions by installing P4 rules to the Stratum switch via the TFS SBI API.

```shell
cd ~/tfs-ctrl/
bash src/tests/p4-int-routing-acl/run_test_02_rules_provision.sh
```

### Step 4: Deprovision rules via the SBI API

Deprovision the routing, ACL, and INT network functions by removing the previously installed P4 rules (via the TFS SBI API) from the Stratum switch.

```shell
cd ~/tfs-ctrl/
bash src/tests/p4-int-routing-acl/run_test_03_rules_deprovision.sh
```

### Step 4: Deprovision topology

Delete all the objects (context, topology, links, devices) from TFS:

```shell
cd ~/tfs-ctrl/
bash src/tests/p4-int-routing-acl/run_test_04_cleanup.sh
```
