/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring;

import eu.teraflow.policy.context.model.Empty;
import eu.teraflow.policy.monitoring.model.AlarmDescriptor;
import eu.teraflow.policy.monitoring.model.AlarmResponse;
import eu.teraflow.policy.monitoring.model.Kpi;
import eu.teraflow.policy.monitoring.model.KpiDescriptor;
import eu.teraflow.policy.monitoring.model.SubsDescriptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class MonitoringServiceImpl implements MonitoringService {

    private final MonitoringGateway monitoringGateway;

    @Inject
    public MonitoringServiceImpl(MonitoringGateway monitoringGateway) {
        this.monitoringGateway = monitoringGateway;
    }

    @Override
    public Uni<String> createKpi(KpiDescriptor kpiDescriptor) {
        return monitoringGateway.createKpi(kpiDescriptor);
    }

    @Override
    public Uni<KpiDescriptor> getKpiDescriptor(String kpiId) {
        return monitoringGateway.getKpiDescriptor(kpiId);
    }

    @Override
    public Multi<List<Kpi>> subscribeKpi(SubsDescriptor subsDescriptor) {
        return monitoringGateway.subscribeKpi(subsDescriptor);
    }

    @Override
    public Uni<SubsDescriptor> getSubsDescriptor(String subscriptionId) {
        return monitoringGateway.getSubsDescriptor(subscriptionId);
    }

    @Override
    public Uni<Empty> editKpiSubscription(SubsDescriptor subsDescriptor) {
        return monitoringGateway.editKpiSubscription(subsDescriptor);
    }

    @Override
    public Uni<String> createKpiAlarm(AlarmDescriptor alarmDescriptor) {
        return monitoringGateway.createKpiAlarm(alarmDescriptor);
    }

    @Override
    public Uni<Empty> editKpiAlarm(AlarmDescriptor alarmDescriptor) {
        return monitoringGateway.editKpiAlarm(alarmDescriptor);
    }

    @Override
    public Uni<AlarmDescriptor> getAlarmDescriptor(String alarmId) {
        return monitoringGateway.getAlarmDescriptor(alarmId);
    }

    @Override
    public Multi<AlarmResponse> getAlarmResponseStream(String alarmId) {
        return monitoringGateway.getAlarmResponseStream(alarmId);
    }

    @Override
    public Uni<Empty> deleteAlarm(String alarmId) {
        return monitoringGateway.deleteAlarm(alarmId);
    }

    @Override
    public Uni<Empty> deleteKpi(String kpiId) {
        return monitoringGateway.deleteKpi(kpiId);
    }
}
