from __future__ import annotations
from typing import TYPE_CHECKING
from ...engines._DatabaseEngine import _DatabaseEngine
from .Tools import format_key

if TYPE_CHECKING:
    from ._Entity import _Entity

class EntityCollection:
    def __init__(self, parent : '_Entity', entity_key : str):
        self._parent = parent
        self._database_engine : _DatabaseEngine = self._parent.database_engine
        self._entity_key_list = format_key(entity_key, self._parent, container_name='_list')
        self._entity_key_set = format_key(entity_key, self._parent, container_name='_set')

    def add(self, entity_uuid : str) -> None:
        if self._database_engine.set_has(self._entity_key_set, entity_uuid): return
        self._database_engine.set_add(self._entity_key_set, entity_uuid)
        self._database_engine.list_push_last(self._entity_key_list, entity_uuid)

    def get(self):
        return self._database_engine.list_get_all(self._entity_key_list)

    def contains(self, entity_uuid : str):
        return self._database_engine.set_has(self._entity_key_set, entity_uuid)

    def delete(self, entity_uuid : str) -> None:
        if not self._database_engine.set_has(self._entity_key_set, entity_uuid): return
        self._database_engine.set_remove(self._entity_key_set, entity_uuid)
        self._database_engine.list_remove_first_occurrence(self._entity_key_list, entity_uuid)
