from enum import Enum

class OperationalStatus(Enum):
    KEEP_STATE = 0  # Do not change operational status of device (used in configure)
    DISABLED = -1
    ENABLED = 1

ANY_TO_ENUM = {
     1: OperationalStatus.ENABLED,
     0: OperationalStatus.KEEP_STATE,
    -1: OperationalStatus.DISABLED,

     '1': OperationalStatus.ENABLED,
     '0': OperationalStatus.KEEP_STATE,
    '-1': OperationalStatus.DISABLED,

    'enabled': OperationalStatus.ENABLED,
    'disabled': OperationalStatus.DISABLED,
    'keep_state': OperationalStatus.KEEP_STATE,
}

def operationalstatus_enum_values():
    return {m.value for m in OperationalStatus.__members__.values()}

def to_operationalstatus_enum(int_or_str):
    if isinstance(int_or_str, str): int_or_str = int_or_str.lower()
    return ANY_TO_ENUM.get(int_or_str)
