# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import pytest
import logging
import time
from telemetry.backend.service.TelemetryBackendService import TelemetryBackendService
from .messages import create_collector_request
from .Fixtures import context_client, device_client
from .add_devices import load_topology

LOGGER = logging.getLogger(__name__)


###########################
# Tests Implementation of Telemetry Backend
###########################

@pytest.fixture(autouse=True)
def log_all_methods(request):
    '''
    This fixture logs messages before and after each test function runs, indicating the start and end of the test.
    The autouse=True parameter ensures that this logging happens automatically for all tests in the module.
    '''
    LOGGER.info(f" >>>>> Starting test: {request.node.name} ")
    yield
    LOGGER.info(f" <<<<< Finished test: {request.node.name} ")

@pytest.fixture
def telemetryBackend_service():
    LOGGER.info('Initializing TelemetryBackendService...')

    _service = TelemetryBackendService()
    _service.start()

    LOGGER.info('Yielding TelemetryBackendService...')
    yield _service

    LOGGER.info('Terminating TelemetryBackendService...')
    _service.stop()
    LOGGER.info('Terminated TelemetryBackendService...')


def test_InitiateCollectorBackend(telemetryBackend_service):
    LOGGER.info(" Backend Initiated Successfully. Waiting for timer to finish ...")
    time.sleep(300)
    LOGGER.info(" Backend Timer Finished Successfully. ")

# --- "test_validate_kafka_topics" should be run before the functionality tests ---
# def test_validate_kafka_topics():
#     LOGGER.debug(" >>> test_validate_kafka_topics: START <<< ")
#     response = KafkaTopic.create_all_topics()
#     assert isinstance(response, bool)

# # Call load_topology from the add_devices.py file
# def test_load_topology(context_client, device_client):
#     load_topology(context_client, device_client)
