# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import supporting_termination_point
from . import te
from . import eth_svc
from . import eth_link_tp
class termination_point(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A termination point can terminate a link.
Depending on the type of topology, a termination point
could, for example, refer to a port or an interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tp_id','__supporting_termination_point','__te_tp_id','__te','__eth_svc','__eth_link_tp',)

  _yang_name = 'termination-point'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tp_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='tp-id', is_config=True)
    self.__supporting_termination_point = YANGDynClass(base=YANGListType("network_ref node_ref tp_ref",supporting_termination_point.supporting_termination_point, yang_name="supporting-termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref tp-ref', extensions=None), is_container='list', yang_name="supporting-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    self.__te_tp_id = YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="te-tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-tp-id', is_config=True)
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__eth_svc = YANGDynClass(base=eth_svc.eth_svc, is_container='container', yang_name="eth-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__eth_link_tp = YANGDynClass(base=eth_link_tp.eth_link_tp, is_container='container', yang_name="eth-link-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point']

  def _get_tp_id(self):
    """
    Getter method for tp_id, mapped from YANG variable /networks/network/node/termination_point/tp_id (tp-id)

    YANG Description: Termination point identifier.
    """
    return self.__tp_id
      
  def _set_tp_id(self, v, load=False):
    """
    Setter method for tp_id, mapped from YANG variable /networks/network/node/termination_point/tp_id (tp-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tp_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tp_id() directly.

    YANG Description: Termination point identifier.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='tp-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tp_id must be of a type compatible with tp-id""",
          'defined-type': "ietf-network-topology:tp-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='tp-id', is_config=True)""",
        })

    self.__tp_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tp_id(self):
    self.__tp_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='tp-id', is_config=True)


  def _get_supporting_termination_point(self):
    """
    Getter method for supporting_termination_point, mapped from YANG variable /networks/network/node/termination_point/supporting_termination_point (list)

    YANG Description: This list identifies any termination points on which a
given termination point depends or onto which it maps.
Those termination points will themselves be contained
in a supporting node.  This dependency information can be
inferred from the dependencies between links.  Therefore,
this item is not separately configurable.  Hence, no
corresponding constraint needs to be articulated.
The corresponding information is simply provided by the
implementing system.
    """
    return self.__supporting_termination_point
      
  def _set_supporting_termination_point(self, v, load=False):
    """
    Setter method for supporting_termination_point, mapped from YANG variable /networks/network/node/termination_point/supporting_termination_point (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supporting_termination_point is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supporting_termination_point() directly.

    YANG Description: This list identifies any termination points on which a
given termination point depends or onto which it maps.
Those termination points will themselves be contained
in a supporting node.  This dependency information can be
inferred from the dependencies between links.  Therefore,
this item is not separately configurable.  Hence, no
corresponding constraint needs to be articulated.
The corresponding information is simply provided by the
implementing system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("network_ref node_ref tp_ref",supporting_termination_point.supporting_termination_point, yang_name="supporting-termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref tp-ref', extensions=None), is_container='list', yang_name="supporting-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supporting_termination_point must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("network_ref node_ref tp_ref",supporting_termination_point.supporting_termination_point, yang_name="supporting-termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref tp-ref', extensions=None), is_container='list', yang_name="supporting-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)""",
        })

    self.__supporting_termination_point = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supporting_termination_point(self):
    self.__supporting_termination_point = YANGDynClass(base=YANGListType("network_ref node_ref tp_ref",supporting_termination_point.supporting_termination_point, yang_name="supporting-termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref tp-ref', extensions=None), is_container='list', yang_name="supporting-termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)


  def _get_te_tp_id(self):
    """
    Getter method for te_tp_id, mapped from YANG variable /networks/network/node/termination_point/te_tp_id (te-types:te-tp-id)

    YANG Description: An identifier that uniquely identifies a TE termination
point.
    """
    return self.__te_tp_id
      
  def _set_te_tp_id(self, v, load=False):
    """
    Setter method for te_tp_id, mapped from YANG variable /networks/network/node/termination_point/te_tp_id (te-types:te-tp-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_tp_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_tp_id() directly.

    YANG Description: An identifier that uniquely identifies a TE termination
point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="te-tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-tp-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_tp_id must be of a type compatible with te-types:te-tp-id""",
          'defined-type': "te-types:te-tp-id",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="te-tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-tp-id', is_config=True)""",
        })

    self.__te_tp_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_tp_id(self):
    self.__te_tp_id = YANGDynClass(base=[RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),], is_leaf=True, yang_name="te-tp-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-tp-id', is_config=True)


  def _get_te(self):
    """
    Getter method for te, mapped from YANG variable /networks/network/node/termination_point/te (container)

    YANG Description: Indicates TE support.
    """
    return self.__te
      
  def _set_te(self, v, load=False):
    """
    Setter method for te, mapped from YANG variable /networks/network/node/termination_point/te (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te() directly.

    YANG Description: Indicates TE support.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te(self):
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_eth_svc(self):
    """
    Getter method for eth_svc, mapped from YANG variable /networks/network/node/termination_point/eth_svc (container)

    YANG Description: ETH LTP Service attributes.
    """
    return self.__eth_svc
      
  def _set_eth_svc(self, v, load=False):
    """
    Setter method for eth_svc, mapped from YANG variable /networks/network/node/termination_point/eth_svc (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_eth_svc is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_eth_svc() directly.

    YANG Description: ETH LTP Service attributes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=eth_svc.eth_svc, is_container='container', yang_name="eth-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """eth_svc must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=eth_svc.eth_svc, is_container='container', yang_name="eth-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__eth_svc = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_eth_svc(self):
    self.__eth_svc = YANGDynClass(base=eth_svc.eth_svc, is_container='container', yang_name="eth-svc", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_eth_link_tp(self):
    """
    Getter method for eth_link_tp, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp (container)

    YANG Description: Attributes of the Ethernet Link Termination Point (LTP).
    """
    return self.__eth_link_tp
      
  def _set_eth_link_tp(self, v, load=False):
    """
    Setter method for eth_link_tp, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_eth_link_tp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_eth_link_tp() directly.

    YANG Description: Attributes of the Ethernet Link Termination Point (LTP).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=eth_link_tp.eth_link_tp, is_container='container', yang_name="eth-link-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """eth_link_tp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=eth_link_tp.eth_link_tp, is_container='container', yang_name="eth-link-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__eth_link_tp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_eth_link_tp(self):
    self.__eth_link_tp = YANGDynClass(base=eth_link_tp.eth_link_tp, is_container='container', yang_name="eth-link-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  tp_id = __builtin__.property(_get_tp_id, _set_tp_id)
  supporting_termination_point = __builtin__.property(_get_supporting_termination_point, _set_supporting_termination_point)
  te_tp_id = __builtin__.property(_get_te_tp_id, _set_te_tp_id)
  te = __builtin__.property(_get_te, _set_te)
  eth_svc = __builtin__.property(_get_eth_svc, _set_eth_svc)
  eth_link_tp = __builtin__.property(_get_eth_link_tp, _set_eth_link_tp)


  _pyangbind_elements = OrderedDict([('tp_id', tp_id), ('supporting_termination_point', supporting_termination_point), ('te_tp_id', te_tp_id), ('te', te), ('eth_svc', eth_svc), ('eth_link_tp', eth_link_tp), ])


