# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import json , logging
from sqlalchemy import Column, String, Integer , ForeignKey, Boolean
from sqlalchemy.dialects.postgresql import ARRAY
from sqlalchemy.orm import relationship
from context.service.database.models._Base import _Base
from .RoadmModel import RoadmTypeModel

class OpticalConfigModel(_Base):
    __tablename__ = 'optical_config'
    opticalconfig_uuid = Column(String, primary_key=True)
    channel_namespace  = Column(String, nullable=True)
    endpoints          = Column(ARRAY(String), nullable=True)
    type               = Column(String,nullable=False)
    
    # transcievers       = Column(ARRAY(String), nullable=True)
    # interfaces         = Column(String, nullable=True)
  
   
    #channels           = relationship("OpticalChannelModel")
    transponders   = relationship("TransponderTypeModel")
    roadms         = relationship("RoadmTypeModel")
    
    
    device_uuid = Column(ForeignKey("device.device_uuid",ondelete="CASCADE"),index=True ,nullable=False)
    device= relationship("DeviceModel",  back_populates='optical_config')
    

    
    def dump_id (self ):
        return {
            "opticalconfig_uuid":self.opticalconfig_uuid,
            "device_uuid" :self.device_uuid
        }

    def dump(self):
        obj={
            # "channels"          : [channel.dump() for channel in self.channels],
            # "transceivers"      : {"transceiver": [transciever for transciever in self.transcievers]},
            # "interfaces"        : {"interface":json.loads(self.interfaces) if self.interfaces else ''},
            "channel_namespace" : self.channel_namespace,
            "endpoints"         : [json.loads(endpoint) for endpoint in self.endpoints if endpoint],
            "device_name"       : self.device.device_name,
            "type"              : self.type
        }
        if self.type =="optical-transponder" :
            channels= [transponer.dump() for transponer in self.transponders ][0]
            obj['channels']=channels['channels'] if 'channels' in channels else None
            obj['transceivers']=channels['transceivers'] if 'transceivers' in channels else None
            obj['interfaces']=channels['interfaces'] if 'interfaces' in channels else None
            obj['trasponder_uuid']=channels['trasponder_uuid'] if 'trasponder_uuid' in channels else None
            
        if self.type =="optical-roadm" :
            channels=[roadms.dump() for roadms in self.roadms ][0]
            obj['channels']=channels['channels'] if 'channels' in channels else None
            obj['roadm_uuid']=channels['roadm_uuid'] if 'roadm_uuid' in channels else None
                
                        
            logging.info(f"optical_config_model {obj}")
        return obj
        
