# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, sys
from .Constants import SERVICE_TYPE_L2NM, SERVICE_TYPE_L3NM, SERVICE_TYPE_TAPI
from .Parameters import Parameters
from .ServiceGenerator import ServiceGenerator
from .ServiceScheduler import ServiceScheduler

logging.basicConfig(level=logging.INFO)
LOGGER = logging.getLogger(__name__)

def main():
    LOGGER.info('Starting...')
    parameters = Parameters(
        num_services  = 100,
        service_types = [
            #SERVICE_TYPE_L2NM,
            #SERVICE_TYPE_L3NM,
            SERVICE_TYPE_TAPI,
        ],
        offered_load  = 50,
        holding_time  = 10,
        dry_mode      = False, # in dry mode, no request is sent to TeraFlowSDN
    )

    LOGGER.info('Initializing Generator...')
    service_generator = ServiceGenerator(parameters)
    service_generator.initialize()

    LOGGER.info('Running Schedule...')
    scheduler = ServiceScheduler(parameters, service_generator)
    scheduler.start()

    LOGGER.info('Done!')
    return 0

if __name__ == '__main__':
    sys.exit(main())
