# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc
from flask import render_template, Blueprint
from common.proto.context_pb2 import Empty
from common.proto.policy_pb2 import PolicyRuleStateEnum
from context.client.ContextClient import ContextClient

policy = Blueprint('policy', __name__, url_prefix='/policy')

context_client = ContextClient()

@policy.get('/')
def home():
    context_client.connect()
    policy_rules = context_client.ListPolicyRules(Empty())
    policy_rules = policy_rules.policyRules
    context_client.close()
    return render_template('policy/home.html', policy_rules=policy_rules, prse=PolicyRuleStateEnum)

#@policy.get('<path:policy_uuid>/detail')
#def detail(policy_uuid: str):
#    try:
#        context_client.connect()
#
#        slice_obj = get_slice_by_uuid(context_client, slice_uuid, rw_copy=False)
#        if slice_obj is None:
#            flash('Context({:s})/Slice({:s}) not found'.format(str(context_uuid), str(slice_uuid)), 'danger')
#            slice_obj = Slice()
#
#        context_client.close()
#
#        return render_template(
#            'slice/detail.html', slice=slice_obj, prse=PolicyRuleStateEnum)
#    except Exception as e:
#        flash('The system encountered an error and cannot show the details of this slice.', 'warning')
#        current_app.logger.exception(e)
#        return redirect(url_for('slice.home'))
