/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Properties;
import jcckit.graphic.BasicGraphicAttributes;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Polygon;
import jcckit.graphic.Rectangle;
import jcckit.graphic.ShapeAttributes;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.ConfigParametersBasedConfigData;
import jcckit.util.Factory;
import jcckit.util.PropertiesBasedConfigData;

public class Legend {
    public static final String UPPER_RIGHT_CORNER_KEY = "upperRightCorner";
    public static final String BOX_WIDTH_KEY = "boxWidth";
    public static final String BOX_HEIGHT_KEY = "boxHeight";
    public static final String BOX_ATTRIBUTES_KEY = "boxAttributes";
    public static final String TITLE_KEY = "title";
    public static final String TITLE_DISTANCE_KEY = "titleDistance";
    public static final String TITLE_ATTRIBUTES_KEY = "titleAttributes";
    public static final String LEFT_DISTANCE_KEY = "leftDistance";
    public static final String BOTTOM_DISTANCE_KEY = "bottomDistance";
    public static final String TOP_DISTANCE_KEY = "topDistance";
    public static final String LINE_LENGTH_KEY = "lineLength";
    public static final String SYMBOL_SIZE_KEY = "symbolSize";
    public static final String CURVE_TITLE_DISTANCE_KEY = "curveTitleDistance";
    public static final String CURVE_TITLE_ATTRIBUTES_KEY = "curveTitleAttributes";
    private final GraphicalComposite _box;
    private final TextAttributes _curveTitleAttributes;
    private final double _xSymbol;
    private final double _xText;
    private final double _yBase;
    private final double _yLastRow;
    private final double _length;
    private final double _size;

    public Legend(ConfigParameters configParameters) {
        configParameters = this.mergeWithDefaultConfig(configParameters);
        GraphPoint graphPoint = new GraphPoint(configParameters.getDoubleArray(UPPER_RIGHT_CORNER_KEY, new double[]{0.94, 0.54}));
        double d = configParameters.getDouble(BOX_WIDTH_KEY, 0.2);
        double d2 = configParameters.getDouble(BOX_HEIGHT_KEY, 0.1);
        this._curveTitleAttributes = (TextAttributes)Factory.create(configParameters.getNode(CURVE_TITLE_ATTRIBUTES_KEY));
        this._xSymbol = graphPoint.getX() - d + configParameters.getDouble(LEFT_DISTANCE_KEY, 0.01);
        this._yBase = graphPoint.getY() - configParameters.getDouble(TOP_DISTANCE_KEY, 0.04);
        this._yLastRow = graphPoint.getY() - d2 + configParameters.getDouble(BOTTOM_DISTANCE_KEY, 0.02);
        this._length = configParameters.getDouble(LINE_LENGTH_KEY, 0.035);
        this._size = configParameters.getDouble(SYMBOL_SIZE_KEY, 0.01);
        this._xText = this._xSymbol + this._length + configParameters.getDouble(CURVE_TITLE_DISTANCE_KEY, 0.005);
        this._box = new GraphicalComposite(null);
        double d3 = graphPoint.getX() - d / 2.0;
        this._box.addElement(new Rectangle(new GraphPoint(d3, graphPoint.getY() - d2 / 2.0), d, d2, (GraphicAttributes)Factory.create(configParameters.getNode(BOX_ATTRIBUTES_KEY))));
        this._box.addElement(new Text(new GraphPoint(d3, graphPoint.getY() - configParameters.getDouble(TITLE_DISTANCE_KEY, 0.005)), configParameters.get(TITLE_KEY, "Legend"), (TextAttributes)Factory.create(configParameters.getNode(TITLE_ATTRIBUTES_KEY))));
    }

    private ConfigParameters mergeWithDefaultConfig(ConfigParameters configParameters) {
        Properties properties = new Properties();
        properties.put("boxAttributes/className", ShapeAttributes.class.getName());
        properties.put("boxAttributes/fillColor", "0xffffff");
        properties.put("boxAttributes/lineColor", "0");
        properties.put("titleAttributes/className", BasicGraphicAttributes.class.getName());
        properties.put("titleAttributes/horizontalAnchor", "center");
        properties.put("titleAttributes/verticalAnchor", "top");
        properties.put("curveTitleAttributes/className", BasicGraphicAttributes.class.getName());
        ConfigData configData = new PropertiesBasedConfigData(properties);
        configData = new ConfigParametersBasedConfigData(configParameters, new ConfigParameters(configData));
        return new ConfigParameters(configData);
    }

    public GraphicalElement getBox() {
        return this._box;
    }

    public GraphicalElement createSymbol(int n, int n2, SymbolFactory symbolFactory, boolean bl, GraphicAttributes graphicAttributes) {
        GraphicalComposite graphicalComposite = new GraphicalComposite(null);
        double d = this.calculateBaseLine(n, n2);
        if (bl) {
            Polygon polygon = new Polygon(graphicAttributes, false);
            polygon.addPoint(new GraphPoint(this._xSymbol, d));
            polygon.addPoint(new GraphPoint(this._xSymbol + this._length, d));
            graphicalComposite.addElement(polygon);
        }
        if (symbolFactory != null) {
            graphicalComposite.addElement(symbolFactory.createLegendSymbol(new GraphPoint(this._xSymbol + this._length / 2.0, d), this._size));
        }
        return graphicalComposite;
    }

    private double calculateBaseLine(int n, int n2) {
        if (n2 > 1) {
            return this._yBase + (this._yLastRow - this._yBase) / (double)(n2 - 1) * (double)n;
        }
        return 0.5 * (this._yBase + this._yLastRow);
    }

    public GraphicalElement createCurveTitle(int n, int n2, String string) {
        return new Text(new GraphPoint(this._xText, this.calculateBaseLine(n, n2)), string, this._curveTitleAttributes);
    }
}

