/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.scandot;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.scandot.ScanDot;
import com.ctreber.acearth.scandot.ScanDotGenerator;
import com.ctreber.acearth.util.Coordinate;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;

public class DotGeneratorLines
extends ScanDotGenerator {
    private Projection fProjection;
    private int fLineDivider;
    private int fPointDivider;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    private static final double HALFPI = 1.5707963267948966;

    public DotGeneratorLines(Projection projection, int n, int n2) {
        this.fProjection = projection;
        this.fLineDivider = n;
        this.fPointDivider = n2;
    }

    public void generateScanDots() {
        double d;
        double d2;
        double d3 = Math.PI * 2 / (double)(this.fLineDivider * 4);
        double d4 = Math.PI / (double)(this.fLineDivider * 2 * this.fPointDivider);
        for (d2 = -Math.PI; d2 <= Math.PI; d2 += d3) {
            for (d = -1.5707963267948966; d <= 1.5707963267948966; d += d4) {
                this.transformAndAddDot(new Coordinate(d, d2));
            }
        }
        d4 = Math.PI * 2 / (double)(this.fLineDivider * 4);
        d3 = Math.PI / (double)(this.fLineDivider * 2 * this.fPointDivider);
        for (d2 = -1.5707963267948966; d2 <= 1.5707963267948966; d2 += d4) {
            for (d = -Math.PI; d <= Math.PI; d += d3) {
                this.transformAndAddDot(new Coordinate(d2, d));
            }
        }
    }

    private void transformAndAddDot(Coordinate coordinate) {
        Point2D point2D;
        Point3D point3D = this.fProjection.rotate(coordinate.getPoint3DRads());
        if (this.fProjection.isVisible(point3D) && this.fProjection.isWithinImage(point2D = this.fProjection.finalize(this.fProjection.project2D(point3D)))) {
            this.fDots.add(new ScanDot(1, point2D));
        }
    }
}

