# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from sqlalchemy import Column, ForeignKey
from sqlalchemy.dialects.postgresql import UUID
from context.service.database._Base import Base

LOGGER = logging.getLogger(__name__)
#
# class ConnectionSubServiceModel(Model): # pylint: disable=abstract-method
#     pk = PrimaryKeyField()
#     connection_fk = ForeignKeyField(ConnectionModel)
#     sub_service_fk = ForeignKeyField(ServiceModel)
#
class LinkEndPointModel(Base): # pylint: disable=abstract-method
    __tablename__ = 'LinkEndPoint'
    # uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)
    link_uuid = Column(UUID(as_uuid=False), ForeignKey("Link.link_uuid"))
    endpoint_uuid = Column(UUID(as_uuid=False), ForeignKey("EndPoint.endpoint_uuid"), primary_key=True)

    @staticmethod
    def main_pk_name():
        return 'endpoint_uuid'

#
# class ServiceEndPointModel(Model): # pylint: disable=abstract-method
#     pk = PrimaryKeyField()
#     service_fk = ForeignKeyField(ServiceModel)
#     endpoint_fk = ForeignKeyField(EndPointModel)
#
# class SliceEndPointModel(Model): # pylint: disable=abstract-method
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     endpoint_fk = ForeignKeyField(EndPointModel)
#
# class SliceServiceModel(Model): # pylint: disable=abstract-method
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     service_fk = ForeignKeyField(ServiceMo# pylint: disable=abstract-method
#     __tablename__ = 'LinkEndPoint'
#     uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)
#     link_uuid = Column(UUID(as_uuid=False), ForeignKey("Link.link_uuid"))
#     endpoint_uuid = Column(UUID(as_uuid=False), ForeignKey("EndPoint.endpoint_uuid"))
#del)
#
# class SliceSubSliceModel(Model): # pylint: disable=abstract-method
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     sub_slice_fk = ForeignKeyField(SliceModel)

class TopologyDeviceModel(Base): # pylint: disable=abstract-method
    __tablename__ = 'TopologyDevice'
    # uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)
    topology_uuid = Column(UUID(as_uuid=False), ForeignKey("Topology.topology_uuid"))
    device_uuid = Column(UUID(as_uuid=False), ForeignKey("Device.device_uuid"), primary_key=True)

    @staticmethod
    def main_pk_name():
        return 'device_uuid'
#
class TopologyLinkModel(Base): # pylint: disable=abstract-method
    __tablename__ = 'TopologyLink'
    topology_uuid = Column(UUID(as_uuid=False), ForeignKey("Topology.topology_uuid"))
    link_uuid = Column(UUID(as_uuid=False), ForeignKey("Link.link_uuid"), primary_key=True)

    @staticmethod
    def main_pk_name():
        return 'link_uuid'