# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, sqlalchemy, sqlalchemy_utils
from common.Settings import get_setting

LOGGER = logging.getLogger(__name__)

APP_NAME = 'tfs'

class Engine:
    def get_engine(self) -> sqlalchemy.engine.Engine:
        ccdb_url = get_setting('CCDB_URL')

        try:
            engine = sqlalchemy.create_engine(
                ccdb_url, connect_args={'application_name': APP_NAME}, echo=False, future=True)
        except: # pylint: disable=bare-except
            LOGGER.exception('Failed to connect to database: {:s}'.format(ccdb_url))
            return None

        try:
            if not sqlalchemy_utils.database_exists(engine.url):
                sqlalchemy_utils.create_database(engine.url)
        except: # pylint: disable=bare-except
            LOGGER.exception('Failed to check/create to database: {:s}'.format(ccdb_url))
            return None

        return engine
