#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

BASE_PATH=~/tfs-ctrl/src/device/service/drivers/gnmi_openconfig
GIT_BASE_PATH=${BASE_PATH}/git/openconfig
OC_PUBLIC_MODELS_PATH=${GIT_BASE_PATH}/public/release/models
IETF_MODELS_PATH=${GIT_BASE_PATH}/public/third_party/ietf
#OC_HERCULES_MODELS_PATH=${GIT_BASE_PATH}/hercules/yang

OUT_FOLDER=openconfig
OUT_PATH=${BASE_PATH}/handlers
cd ${OUT_PATH}
export PYBINDPLUGIN=`/usr/bin/env python -c 'import pyangbind; import os; print ("{}/plugin".format(os.path.dirname(pyangbind.__file__)))'`

# -p ${OC_HERCULES_MODELS_PATH}/
# --split-class-dir openconfig_hercules
pyang --plugindir $PYBINDPLUGIN -p ${OC_PUBLIC_MODELS_PATH}/ -f pybind --split-class-dir ${OUT_FOLDER} \
    ${IETF_MODELS_PATH}/iana-if-type.yang                                               \
    ${IETF_MODELS_PATH}/ietf-interfaces.yang                                            \
    ${IETF_MODELS_PATH}/ietf-yang-types.yang                                            \
    ${OC_PUBLIC_MODELS_PATH}/acl/openconfig-icmpv4-types.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/acl/openconfig-icmpv6-types.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/acl/openconfig-packet-match-types.yang                     \
    ${OC_PUBLIC_MODELS_PATH}/acl/openconfig-packet-match.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/defined-sets/openconfig-defined-sets.yang                  \
    ${OC_PUBLIC_MODELS_PATH}/interfaces/openconfig-if-aggregate.yang                    \
    ${OC_PUBLIC_MODELS_PATH}/interfaces/openconfig-if-ethernet.yang                     \
    ${OC_PUBLIC_MODELS_PATH}/interfaces/openconfig-if-ip.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/interfaces/openconfig-interfaces.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/mpls/openconfig-mpls-types.yang                            \
    ${OC_PUBLIC_MODELS_PATH}/openconfig-extensions.yang                                 \
    ${OC_PUBLIC_MODELS_PATH}/optical-transport/openconfig-transport-types.yang          \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-common.yang                   \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-controller-card.yang          \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-cpu.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-ext.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-fabric.yang                   \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-fan.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-healthz.yang                  \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-integrated-circuit.yang       \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-linecard.yang                 \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-pipeline-counters.yang        \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-port.yang                     \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-psu.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-software.yang                 \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-transceiver.yang              \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform-types.yang                    \
    ${OC_PUBLIC_MODELS_PATH}/platform/openconfig-platform.yang                          \
    ${OC_PUBLIC_MODELS_PATH}/qos/openconfig-qos-elements.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/qos/openconfig-qos-interfaces.yang                         \
    ${OC_PUBLIC_MODELS_PATH}/qos/openconfig-qos-mem-mgmt.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/qos/openconfig-qos-types.yang                              \
    ${OC_PUBLIC_MODELS_PATH}/qos/openconfig-qos.yang                                    \
    ${OC_PUBLIC_MODELS_PATH}/system/openconfig-alarm-types.yang                         \
    ${OC_PUBLIC_MODELS_PATH}/types/openconfig-inet-types.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/types/openconfig-types.yang                                \
    ${OC_PUBLIC_MODELS_PATH}/types/openconfig-yang-types.yang                           \
    ${OC_PUBLIC_MODELS_PATH}/vlan/openconfig-vlan-types.yang                            \
    ${OC_PUBLIC_MODELS_PATH}/vlan/openconfig-vlan.yang                                  \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-network-instance.yang          \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-network-instance-l2.yang       \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-network-instance-l3.yang       \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-network-instance-types.yang    \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-evpn.yang                      \
    ${OC_PUBLIC_MODELS_PATH}/network-instance/openconfig-evpn-types.yang                \
    ${OC_PUBLIC_MODELS_PATH}/bgp/openconfig-bgp-types.yang                              \
    ${OC_PUBLIC_MODELS_PATH}/bgp/openconfig-bgp-errors.yang                             \


openconfig-aft
openconfig-bgp
openconfig-igmp
openconfig-isis
openconfig-local-routing
openconfig-mpls
openconfig-ospfv2
openconfig-pcep
openconfig-pim
openconfig-policy-forwarding
openconfig-policy-types
openconfig-routing-policy
openconfig-segment-routing




#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-interfaces.yang             \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-platform-chassis.yang       \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-platform-linecard.yang      \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-platform-node.yang          \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-platform-port.yang          \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-platform.yang               \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules-qos.yang                    \
#    ${OC_HERCULES_MODELS_PATH}/openconfig-hercules.yang                        \
