# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
import os
from unittest.mock import patch

import pytest

from common.Constants import (DEFAULT_GRPC_GRACE_PERIOD,
                              DEFAULT_GRPC_MAX_WORKERS,
                              DEFAULT_SERVICE_GRPC_PORTS, ServiceNameEnum)
from common.proto import dbscanserving_pb2 as dbscan
from common.proto.optical_attack_detector_pb2 import DetectionRequest
from opticalattackdetector.client.OpticalAttackDetectorClient import \
    OpticalAttackDetectorClient
from opticalattackdetector.Config import GRPC_SERVICE_PORT
from opticalattackdetector.service.OpticalAttackDetectorService import \
    OpticalAttackDetectorService

# from .example_objects import CONTEXT_ID, CONTEXT_ID_2, SERVICE_DEV1_DEV2

port = 10000 + GRPC_SERVICE_PORT  # avoid privileged ports

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)


@pytest.fixture(scope="session")
def optical_attack_detector_service():
    with patch.dict(
        os.environ,
        {
            "OPTICALATTACKDETECTORSERVICE_SERVICE_HOST": "127.0.0.1",
            "OPTICALATTACKDETECTORSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(
                    ServiceNameEnum.OPTICALATTACKDETECTOR.value
                )
            ),
            "OPTICALATTACKMITIGATORSERVICE_SERVICE_HOST": "127.0.0.1",
            "OPTICALATTACKMITIGATORSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(
                    ServiceNameEnum.OPTICALATTACKMITIGATOR.value
                )
            ),
            "DBSCANSERVINGSERVICE_SERVICE_HOST": "127.0.0.1",
            "DBSCANSERVINGSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(ServiceNameEnum.DBSCANSERVING.value)
            ),
        },
        clear=True,
    ):
        _service = OpticalAttackDetectorService(
            port=port,
            max_workers=DEFAULT_GRPC_MAX_WORKERS,
            grace_period=DEFAULT_GRPC_GRACE_PERIOD,
        )
        # mocker_context_client = mock.patch('opticalattackdetector.service.OpticalAttackDetectorServiceServicerImpl.context_client')
        # mocker_context_client.start()

        # mocker_influx_db = mock.patch('opticalattackdetector.service.OpticalAttackDetectorServiceServicerImpl.influxdb_client')
        # mocker_influx_db.start()

        _service.start()
        yield _service
        _service.stop()
        # mocker_context_client.stop()
        # mocker_influx_db.stop()


@pytest.fixture(scope="session")
def optical_attack_detector_client(optical_attack_detector_service):
    with patch.dict(
        os.environ,
        {
            "OPTICALATTACKDETECTORSERVICE_SERVICE_HOST": "127.0.0.1",
            "OPTICALATTACKDETECTORSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(
                    ServiceNameEnum.OPTICALATTACKDETECTOR.value
                )
            ),
            "OPTICALATTACKMITIGATORSERVICE_SERVICE_HOST": "127.0.0.1",
            "OPTICALATTACKMITIGATORSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(
                    ServiceNameEnum.OPTICALATTACKMITIGATOR.value
                )
            ),
            "DBSCANSERVINGSERVICE_SERVICE_HOST": "127.0.0.1",
            "DBSCANSERVINGSERVICE_SERVICE_PORT_GRPC": str(
                1000
                + DEFAULT_SERVICE_GRPC_PORTS.get(ServiceNameEnum.DBSCANSERVING.value)
            ),
        },
        clear=True,
    ):
        _client = OpticalAttackDetectorClient()
        yield _client
    _client.close()


def test_detect_attack(
    optical_attack_detector_client: OpticalAttackDetectorClient,
):
    LOGGER.info("placeholder")
