from __future__ import annotations
from typing import TYPE_CHECKING
from common.type_checkers.Checkers import chk_issubclass, chk_type
from .StringField import StringField

if TYPE_CHECKING:
    from ..model.Model import Model

class ForeignKeyField(StringField):
    def __init__(self, foreign_model : 'Model', *args, required : bool = True, **kwargs) -> None:
        from ..model.Model import Model
        self.foreign_model : Model = chk_issubclass('ForeignKeyField.foreign_model', foreign_model, Model)
        super().__init__(*args, required=required, allow_empty=not required, **kwargs)

    def __set__(self, instance : 'Model', value : 'Model') -> None:
        model_instance : 'Model' = chk_type('value', value, self.foreign_model)
        super().__set__(instance, self.validate(model_instance.instance_key))

    def __delete__(self, instance: 'Model'):
        super().__set__(instance, self.validate(None))
