#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


rm -rf tmp/exec

echo "Collecting logs for Domain 1..."
mkdir -p tmp/exec/dom1
kubectl --namespace tfs-dom1 logs deployments/contextservice server > tmp/exec/dom1/context.log
kubectl --namespace tfs-dom1 logs deployments/deviceservice server > tmp/exec/dom1/device.log
kubectl --namespace tfs-dom1 logs deployments/serviceservice server > tmp/exec/dom1/service.log
kubectl --namespace tfs-dom1 logs deployments/pathcompservice frontend > tmp/exec/dom1/pathcomp-frontend.log
kubectl --namespace tfs-dom1 logs deployments/pathcompservice backend > tmp/exec/dom1/pathcomp-backend.log
kubectl --namespace tfs-dom1 logs deployments/sliceservice server > tmp/exec/dom1/slice.log
kubectl --namespace tfs-dom1 logs deployment/interdomainservice server > tmp/exec/dom1/interdomain.log
printf "\n"

echo "Collecting logs for Domain 2..."
mkdir -p tmp/exec/dom2
kubectl --namespace tfs-dom2 logs deployments/contextservice server > tmp/exec/dom2/context.log
kubectl --namespace tfs-dom2 logs deployments/deviceservice server > tmp/exec/dom2/device.log
kubectl --namespace tfs-dom2 logs deployments/serviceservice server > tmp/exec/dom2/service.log
kubectl --namespace tfs-dom2 logs deployments/pathcompservice frontend > tmp/exec/dom2/pathcomp-frontend.log
kubectl --namespace tfs-dom2 logs deployments/pathcompservice backend > tmp/exec/dom2/pathcomp-backend.log
kubectl --namespace tfs-dom2 logs deployments/sliceservice server > tmp/exec/dom2/slice.log
kubectl --namespace tfs-dom2 logs deployment/interdomainservice server > tmp/exec/dom2/interdomain.log
printf "\n"

echo "Done!"
