/*
* Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring.model;

public class AlarmSubscription {

    private final String alarmId;
    private final float subscriptionTimeoutS;
    private final float subscriptionFrequencyMs;

    public AlarmSubscription(
            String alarmId, float subscriptionTimeoutS, float subscriptionFrequencyMs) {
        this.alarmId = alarmId;
        this.subscriptionTimeoutS = subscriptionTimeoutS;
        this.subscriptionFrequencyMs = subscriptionFrequencyMs;
    }

    public String getAlarmId() {
        return alarmId;
    }

    public float getSubscriptionTimeoutS() {
        return subscriptionTimeoutS;
    }

    public float getSubscriptionFrequencyMs() {
        return subscriptionFrequencyMs;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{alarmId:\"%s\", subscriptionTimeoutS:\"%f\", subscriptionFrequencyMs:\"%f\"}",
                getClass().getSimpleName(), alarmId, subscriptionTimeoutS, subscriptionFrequencyMs);
    }
}
