# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# this script opens the webui

K8S_NAMESPACE=${K8S_NAMESPACE:-'tfs'}

WEBUI_SERVICE_NAME="webuiservice"
WEBUI_IP=`kubectl get service ${WEBUI_SERVICE_NAME} -n ${K8S_NAMESPACE} -o jsonpath='{.spec.clusterIP}'`
# WEBUI_PORT=$(kubectl get service ${WEBUI_SERVICE_NAME} --namespace $K8S_NAMESPACE -o 'jsonpath={.spec.ports[?(@.port==8004)].nodePort}')
WEBUI_PORT=8004
# GRAFANA_PORT=$(kubectl get service ${WEBUI_SERVICE_NAME} --namespace $K8S_NAMESPACE -o 'jsonpath={.spec.ports[?(@.port==3000)].nodePort}')
GRAFANA_PORT=3000

# Open WebUI
UI_URL="http://${WEBUI_IP}:${WEBUI_PORT}"
echo "Opening web UI on URL ${UI_URL}"
# curl -kL ${UI_URL}
python3 -m webbrowser ${UI_URL}

# Open Dashboard
DASHB_URL="http://${WEBUI_IP}:${GRAFANA_PORT}"
echo "Opening Dashboard on URL ${DASHB_URL}"
# curl -kL ${DASHB_URL}
python3 -m webbrowser ${DASHB_URL}
