# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import copy, grpc, logging, pytest
from common.database.Factory import get_database, DatabaseEngineEnum
from slice.client.SliceClient import SliceClient
from slice.proto.slice_pb2 import TransportSlice
from slice.service.SliceService import SliceService
from slice.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD

port = 10000 + GRPC_SERVICE_PORT # avoid privileged ports

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def slice_database():
    _database = get_database(engine=DatabaseEngineEnum.INMEMORY)
    return _database

@pytest.fixture(scope='session')
def slice_service(slice_database):
    _service = SliceService(
        slice_database, port=port, max_workers=GRPC_MAX_WORKERS, grace_period=GRPC_GRACE_PERIOD)
    _service.start()
    yield _service
    _service.stop()

@pytest.fixture(scope='session')
def slice_client(slice_service):
    _client = SliceClient(address='127.0.0.1', port=port)
    yield _client
    _client.close()

#def test_add_device_wrong_attributes(slice_client : SliceClient):
#    # should fail with slice uuid is empty
#    with pytest.raises(grpc._channel._InactiveRpcError) as e:
#        slice_client.CreateUpdateSlice(TransportSlice())
#    assert e.value.code() == grpc.StatusCode.INVALID_ARGUMENT
#    assert e.value.details() == 'slice.slice_id.slice_id.uuid() string is empty.'
