# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import external_domain
from . import underlay
from . import interface_switching_capability
from . import label_restrictions
from . import max_link_bandwidth
from . import max_resv_link_bandwidth
from . import unreserved_bandwidth
from . import te_srlgs
from . import te_nsrlgs
class te_link_attributes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/te/templates/link-template/te-link-attributes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Link attributes in a TE topology.
  """
  __slots__ = ('_path_helper', '_extmethods', '__access_type','__external_domain','__is_abstract','__name','__underlay','__admin_status','__link_index','__administrative_group','__interface_switching_capability','__label_restrictions','__link_protection_type','__max_link_bandwidth','__max_resv_link_bandwidth','__unreserved_bandwidth','__te_default_metric','__te_delay_metric','__te_igp_metric','__te_srlgs','__te_nsrlgs',)

  _yang_name = 'te-link-attributes'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__access_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'point-to-point': {}, 'multi-access': {}},), is_leaf=True, yang_name="access-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-link-access-type', is_config=True)
    self.__external_domain = YANGDynClass(base=external_domain.external_domain, is_container='container', yang_name="external-domain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__is_abstract = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=True)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)
    self.__link_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="link-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=True)
    self.__administrative_group = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), restriction_dict={'length': ['1..11']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}),], is_leaf=True, yang_name="administrative-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:admin-groups', is_config=True)
    self.__interface_switching_capability = YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__link_protection_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="link-protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__max_link_bandwidth = YANGDynClass(base=max_link_bandwidth.max_link_bandwidth, is_container='container', yang_name="max-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__max_resv_link_bandwidth = YANGDynClass(base=max_resv_link_bandwidth.max_resv_link_bandwidth, is_container='container', yang_name="max-resv-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__unreserved_bandwidth = YANGDynClass(base=YANGListType("priority",unreserved_bandwidth.unreserved_bandwidth, yang_name="unreserved-bandwidth", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='priority', extensions=None), is_container='list', yang_name="unreserved-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    self.__te_default_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-default-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__te_delay_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-delay-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__te_igp_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-igp-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__te_srlgs = YANGDynClass(base=te_srlgs.te_srlgs, is_container='container', yang_name="te-srlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__te_nsrlgs = YANGDynClass(base=te_nsrlgs.te_nsrlgs, is_container='container', yang_name="te-nsrlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'te', 'templates', 'link-template', 'te-link-attributes']

  def _get_access_type(self):
    """
    Getter method for access_type, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/access_type (te-types:te-link-access-type)

    YANG Description: Link access type, which can be point-to-point or
multi-access.
    """
    return self.__access_type
      
  def _set_access_type(self, v, load=False):
    """
    Setter method for access_type, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/access_type (te-types:te-link-access-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_access_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_access_type() directly.

    YANG Description: Link access type, which can be point-to-point or
multi-access.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'point-to-point': {}, 'multi-access': {}},), is_leaf=True, yang_name="access-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-link-access-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """access_type must be of a type compatible with te-types:te-link-access-type""",
          'defined-type': "te-types:te-link-access-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'point-to-point': {}, 'multi-access': {}},), is_leaf=True, yang_name="access-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-link-access-type', is_config=True)""",
        })

    self.__access_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_access_type(self):
    self.__access_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'point-to-point': {}, 'multi-access': {}},), is_leaf=True, yang_name="access-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-link-access-type', is_config=True)


  def _get_external_domain(self):
    """
    Getter method for external_domain, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/external_domain (container)

    YANG Description: For an inter-domain link, specifies the attributes of
the remote end of the link, to facilitate the signaling at
the local end.
    """
    return self.__external_domain
      
  def _set_external_domain(self, v, load=False):
    """
    Setter method for external_domain, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/external_domain (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_external_domain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_external_domain() directly.

    YANG Description: For an inter-domain link, specifies the attributes of
the remote end of the link, to facilitate the signaling at
the local end.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=external_domain.external_domain, is_container='container', yang_name="external-domain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """external_domain must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=external_domain.external_domain, is_container='container', yang_name="external-domain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__external_domain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_external_domain(self):
    self.__external_domain = YANGDynClass(base=external_domain.external_domain, is_container='container', yang_name="external-domain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_is_abstract(self):
    """
    Getter method for is_abstract, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/is_abstract (empty)

    YANG Description: Present if the link is abstract.
    """
    return self.__is_abstract
      
  def _set_is_abstract(self, v, load=False):
    """
    Setter method for is_abstract, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/is_abstract (empty)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_is_abstract is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_is_abstract() directly.

    YANG Description: Present if the link is abstract.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """is_abstract must be of a type compatible with empty""",
          'defined-type': "empty",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=True)""",
        })

    self.__is_abstract = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_is_abstract(self):
    self.__is_abstract = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=True)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/name (string)

    YANG Description: Link name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Link name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=True)


  def _get_underlay(self):
    """
    Getter method for underlay, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay (container)

    YANG Description: Attributes of the TE link underlay.
    """
    return self.__underlay
      
  def _set_underlay(self, v, load=False):
    """
    Setter method for underlay, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_underlay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_underlay() directly.

    YANG Description: Attributes of the TE link underlay.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """underlay must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__underlay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_underlay(self):
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/admin_status (te-types:te-admin-status)

    YANG Description: The administrative state of the link.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/admin_status (te-types:te-admin-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The administrative state of the link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with te-types:te-admin-status""",
          'defined-type': "te-types:te-admin-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-admin-status', is_config=True)


  def _get_link_index(self):
    """
    Getter method for link_index, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/link_index (uint64)

    YANG Description: The link identifier.  If OSPF is used, this object
represents an ospfLsdbID.  If IS-IS is used, this object
represents an isisLSPID.  If a locally configured link is
used, this object represents a unique value, which is
locally defined in a router.
    """
    return self.__link_index
      
  def _set_link_index(self, v, load=False):
    """
    Setter method for link_index, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/link_index (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_index() directly.

    YANG Description: The link identifier.  If OSPF is used, this object
represents an ospfLsdbID.  If IS-IS is used, this object
represents an isisLSPID.  If a locally configured link is
used, this object represents a unique value, which is
locally defined in a router.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="link-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_index must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="link-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=True)""",
        })

    self.__link_index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_index(self):
    self.__link_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="link-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=True)


  def _get_administrative_group(self):
    """
    Getter method for administrative_group, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/administrative_group (te-types:admin-groups)

    YANG Description: Administrative group or color of the link.
This attribute covers both administrative groups (defined
in RFCs 3630 and 5305) and Extended Administrative Groups
(defined in RFC 7308).
    """
    return self.__administrative_group
      
  def _set_administrative_group(self, v, load=False):
    """
    Setter method for administrative_group, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/administrative_group (te-types:admin-groups)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_administrative_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_administrative_group() directly.

    YANG Description: Administrative group or color of the link.
This attribute covers both administrative groups (defined
in RFCs 3630 and 5305) and Extended Administrative Groups
(defined in RFC 7308).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), restriction_dict={'length': ['1..11']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}),], is_leaf=True, yang_name="administrative-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:admin-groups', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """administrative_group must be of a type compatible with te-types:admin-groups""",
          'defined-type': "te-types:admin-groups",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), restriction_dict={'length': ['1..11']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}),], is_leaf=True, yang_name="administrative-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:admin-groups', is_config=True)""",
        })

    self.__administrative_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_administrative_group(self):
    self.__administrative_group = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), restriction_dict={'length': ['1..11']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}),], is_leaf=True, yang_name="administrative-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:admin-groups', is_config=True)


  def _get_interface_switching_capability(self):
    """
    Getter method for interface_switching_capability, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/interface_switching_capability (list)

    YANG Description: List of ISCDs for this link.
    """
    return self.__interface_switching_capability
      
  def _set_interface_switching_capability(self, v, load=False):
    """
    Setter method for interface_switching_capability, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/interface_switching_capability (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_switching_capability is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_switching_capability() directly.

    YANG Description: List of ISCDs for this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_switching_capability must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__interface_switching_capability = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_switching_capability(self):
    self.__interface_switching_capability = YANGDynClass(base=YANGListType("switching_capability encoding",interface_switching_capability.interface_switching_capability, yang_name="interface-switching-capability", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='switching-capability encoding', extensions=None), is_container='list', yang_name="interface-switching-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)


  def _get_label_restrictions(self):
    """
    Getter method for label_restrictions, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/label_restrictions (container)

    YANG Description: The label restrictions container.
    """
    return self.__label_restrictions
      
  def _set_label_restrictions(self, v, load=False):
    """
    Setter method for label_restrictions, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/label_restrictions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_restrictions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_restrictions() directly.

    YANG Description: The label restrictions container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_restrictions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__label_restrictions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_restrictions(self):
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_link_protection_type(self):
    """
    Getter method for link_protection_type, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/link_protection_type (identityref)

    YANG Description: Link Protection Type desired for this link.
    """
    return self.__link_protection_type
      
  def _set_link_protection_type(self, v, load=False):
    """
    Setter method for link_protection_type, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/link_protection_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_protection_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_protection_type() directly.

    YANG Description: Link Protection Type desired for this link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="link-protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_protection_type must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="link-protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__link_protection_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_protection_type(self):
    self.__link_protection_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="link-protection-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_max_link_bandwidth(self):
    """
    Getter method for max_link_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/max_link_bandwidth (container)

    YANG Description: Maximum bandwidth that can be seen on this link in this
direction.  Units are in bytes per second.
    """
    return self.__max_link_bandwidth
      
  def _set_max_link_bandwidth(self, v, load=False):
    """
    Setter method for max_link_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/max_link_bandwidth (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_link_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_link_bandwidth() directly.

    YANG Description: Maximum bandwidth that can be seen on this link in this
direction.  Units are in bytes per second.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=max_link_bandwidth.max_link_bandwidth, is_container='container', yang_name="max-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_link_bandwidth must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=max_link_bandwidth.max_link_bandwidth, is_container='container', yang_name="max-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__max_link_bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_link_bandwidth(self):
    self.__max_link_bandwidth = YANGDynClass(base=max_link_bandwidth.max_link_bandwidth, is_container='container', yang_name="max-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_max_resv_link_bandwidth(self):
    """
    Getter method for max_resv_link_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/max_resv_link_bandwidth (container)

    YANG Description: Maximum amount of bandwidth that can be reserved in this
direction in this link.  Units are in bytes per second.
    """
    return self.__max_resv_link_bandwidth
      
  def _set_max_resv_link_bandwidth(self, v, load=False):
    """
    Setter method for max_resv_link_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/max_resv_link_bandwidth (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_resv_link_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_resv_link_bandwidth() directly.

    YANG Description: Maximum amount of bandwidth that can be reserved in this
direction in this link.  Units are in bytes per second.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=max_resv_link_bandwidth.max_resv_link_bandwidth, is_container='container', yang_name="max-resv-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_resv_link_bandwidth must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=max_resv_link_bandwidth.max_resv_link_bandwidth, is_container='container', yang_name="max-resv-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__max_resv_link_bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_resv_link_bandwidth(self):
    self.__max_resv_link_bandwidth = YANGDynClass(base=max_resv_link_bandwidth.max_resv_link_bandwidth, is_container='container', yang_name="max-resv-link-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_unreserved_bandwidth(self):
    """
    Getter method for unreserved_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/unreserved_bandwidth (list)

    YANG Description: Unreserved bandwidth for priority levels 0-7.  Units are in
bytes per second.
    """
    return self.__unreserved_bandwidth
      
  def _set_unreserved_bandwidth(self, v, load=False):
    """
    Setter method for unreserved_bandwidth, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/unreserved_bandwidth (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unreserved_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unreserved_bandwidth() directly.

    YANG Description: Unreserved bandwidth for priority levels 0-7.  Units are in
bytes per second.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("priority",unreserved_bandwidth.unreserved_bandwidth, yang_name="unreserved-bandwidth", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='priority', extensions=None), is_container='list', yang_name="unreserved-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unreserved_bandwidth must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("priority",unreserved_bandwidth.unreserved_bandwidth, yang_name="unreserved-bandwidth", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='priority', extensions=None), is_container='list', yang_name="unreserved-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__unreserved_bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unreserved_bandwidth(self):
    self.__unreserved_bandwidth = YANGDynClass(base=YANGListType("priority",unreserved_bandwidth.unreserved_bandwidth, yang_name="unreserved-bandwidth", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='priority', extensions=None), is_container='list', yang_name="unreserved-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)


  def _get_te_default_metric(self):
    """
    Getter method for te_default_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_default_metric (uint32)

    YANG Description: Traffic Engineering metric.
    """
    return self.__te_default_metric
      
  def _set_te_default_metric(self, v, load=False):
    """
    Setter method for te_default_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_default_metric (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_default_metric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_default_metric() directly.

    YANG Description: Traffic Engineering metric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-default-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_default_metric must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-default-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__te_default_metric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_default_metric(self):
    self.__te_default_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-default-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_te_delay_metric(self):
    """
    Getter method for te_delay_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_delay_metric (uint32)

    YANG Description: Traffic Engineering delay metric.
    """
    return self.__te_delay_metric
      
  def _set_te_delay_metric(self, v, load=False):
    """
    Setter method for te_delay_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_delay_metric (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_delay_metric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_delay_metric() directly.

    YANG Description: Traffic Engineering delay metric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-delay-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_delay_metric must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-delay-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__te_delay_metric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_delay_metric(self):
    self.__te_delay_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-delay-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_te_igp_metric(self):
    """
    Getter method for te_igp_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_igp_metric (uint32)

    YANG Description: IGP metric used for Traffic Engineering.
    """
    return self.__te_igp_metric
      
  def _set_te_igp_metric(self, v, load=False):
    """
    Setter method for te_igp_metric, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_igp_metric (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_igp_metric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_igp_metric() directly.

    YANG Description: IGP metric used for Traffic Engineering.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-igp-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_igp_metric must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-igp-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__te_igp_metric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_igp_metric(self):
    self.__te_igp_metric = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="te-igp-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_te_srlgs(self):
    """
    Getter method for te_srlgs, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_srlgs (container)

    YANG Description: Contains a list of SRLGs.
    """
    return self.__te_srlgs
      
  def _set_te_srlgs(self, v, load=False):
    """
    Setter method for te_srlgs, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_srlgs (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_srlgs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_srlgs() directly.

    YANG Description: Contains a list of SRLGs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_srlgs.te_srlgs, is_container='container', yang_name="te-srlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_srlgs must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_srlgs.te_srlgs, is_container='container', yang_name="te-srlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_srlgs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_srlgs(self):
    self.__te_srlgs = YANGDynClass(base=te_srlgs.te_srlgs, is_container='container', yang_name="te-srlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_te_nsrlgs(self):
    """
    Getter method for te_nsrlgs, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_nsrlgs (container)

    YANG Description: Contains a list of NSRLGs (Non-Shared Risk Link Groups).
When an abstract TE link is configured, this list specifies
the request that underlay TE paths need to be mutually
disjoint with other TE links in the same groups.
    """
    return self.__te_nsrlgs
      
  def _set_te_nsrlgs(self, v, load=False):
    """
    Setter method for te_nsrlgs, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/te_nsrlgs (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_nsrlgs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_nsrlgs() directly.

    YANG Description: Contains a list of NSRLGs (Non-Shared Risk Link Groups).
When an abstract TE link is configured, this list specifies
the request that underlay TE paths need to be mutually
disjoint with other TE links in the same groups.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_nsrlgs.te_nsrlgs, is_container='container', yang_name="te-nsrlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_nsrlgs must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_nsrlgs.te_nsrlgs, is_container='container', yang_name="te-nsrlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_nsrlgs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_nsrlgs(self):
    self.__te_nsrlgs = YANGDynClass(base=te_nsrlgs.te_nsrlgs, is_container='container', yang_name="te-nsrlgs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  access_type = __builtin__.property(_get_access_type, _set_access_type)
  external_domain = __builtin__.property(_get_external_domain, _set_external_domain)
  is_abstract = __builtin__.property(_get_is_abstract, _set_is_abstract)
  name = __builtin__.property(_get_name, _set_name)
  underlay = __builtin__.property(_get_underlay, _set_underlay)
  admin_status = __builtin__.property(_get_admin_status, _set_admin_status)
  link_index = __builtin__.property(_get_link_index, _set_link_index)
  administrative_group = __builtin__.property(_get_administrative_group, _set_administrative_group)
  interface_switching_capability = __builtin__.property(_get_interface_switching_capability, _set_interface_switching_capability)
  label_restrictions = __builtin__.property(_get_label_restrictions, _set_label_restrictions)
  link_protection_type = __builtin__.property(_get_link_protection_type, _set_link_protection_type)
  max_link_bandwidth = __builtin__.property(_get_max_link_bandwidth, _set_max_link_bandwidth)
  max_resv_link_bandwidth = __builtin__.property(_get_max_resv_link_bandwidth, _set_max_resv_link_bandwidth)
  unreserved_bandwidth = __builtin__.property(_get_unreserved_bandwidth, _set_unreserved_bandwidth)
  te_default_metric = __builtin__.property(_get_te_default_metric, _set_te_default_metric)
  te_delay_metric = __builtin__.property(_get_te_delay_metric, _set_te_delay_metric)
  te_igp_metric = __builtin__.property(_get_te_igp_metric, _set_te_igp_metric)
  te_srlgs = __builtin__.property(_get_te_srlgs, _set_te_srlgs)
  te_nsrlgs = __builtin__.property(_get_te_nsrlgs, _set_te_nsrlgs)


  _pyangbind_elements = OrderedDict([('access_type', access_type), ('external_domain', external_domain), ('is_abstract', is_abstract), ('name', name), ('underlay', underlay), ('admin_status', admin_status), ('link_index', link_index), ('administrative_group', administrative_group), ('interface_switching_capability', interface_switching_capability), ('label_restrictions', label_restrictions), ('link_protection_type', link_protection_type), ('max_link_bandwidth', max_link_bandwidth), ('max_resv_link_bandwidth', max_resv_link_bandwidth), ('unreserved_bandwidth', unreserved_bandwidth), ('te_default_metric', te_default_metric), ('te_delay_metric', te_delay_metric), ('te_igp_metric', te_igp_metric), ('te_srlgs', te_srlgs), ('te_nsrlgs', te_nsrlgs), ])


