/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.Slot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotSet
implements Iterable<Slot> {
    private final List<Slot> all = new ArrayList<Slot>();

    public void addSlot(double d, double d2) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        Slot slot = new Slot(d, d2);
        Iterator<Slot> iterator = this.all.iterator();
        while (iterator.hasNext()) {
            Slot slot2 = iterator.next();
            if (!slot2.intersect(slot)) continue;
            iterator.remove();
            arrayList.add(slot2);
        }
        for (Slot slot2 : arrayList) {
            slot = slot.merge(slot2);
        }
        this.all.add(slot);
    }

    public SlotSet smaller(double d) {
        SlotSet slotSet = new SlotSet();
        for (Slot slot : this.all) {
            if (slot.size() <= 2.0 * d) continue;
            slotSet.addSlot(slot.getStart() + d, slot.getEnd() - d);
        }
        return slotSet;
    }

    public String toString() {
        return this.all.toString();
    }

    public List<Slot> getSlots() {
        return Collections.unmodifiableList(this.all);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.getSlots().iterator();
    }

    public SlotSet reverse() {
        SlotSet slotSet = new SlotSet();
        Collections.sort(this.all);
        Slot slot = null;
        for (Slot slot2 : this.all) {
            if (slot != null) {
                slotSet.addSlot(slot.getEnd(), slot2.getStart());
            }
            slot = slot2;
        }
        return slotSet;
    }
}

