# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class ethernet_label_range(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/to/label-restrictions/label-restriction/ethernet-label-range. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet-specific label range related information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tag_type','__priority',)

  _yang_name = 'ethernet-label-range'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tag_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="tag-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=False)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'to', 'label-restrictions', 'label-restriction', 'ethernet-label-range']

  def _get_tag_type(self):
    """
    Getter method for tag_type, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/ethernet_label_range/tag_type (etht-types:eth-tag-type)

    YANG Description: VLAN tag type.
    """
    return self.__tag_type
      
  def _set_tag_type(self, v, load=False):
    """
    Setter method for tag_type, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/ethernet_label_range/tag_type (etht-types:eth-tag-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tag_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tag_type() directly.

    YANG Description: VLAN tag type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="tag-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tag_type must be of a type compatible with etht-types:eth-tag-type""",
          'defined-type': "etht-types:eth-tag-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="tag-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=False)""",
        })

    self.__tag_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tag_type(self):
    self.__tag_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},), is_leaf=True, yang_name="tag-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=False)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/ethernet_label_range/priority (uint8)

    YANG Description: priority.
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/ethernet_label_range/priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: priority.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=False)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=False)

  tag_type = __builtin__.property(_get_tag_type)
  priority = __builtin__.property(_get_priority)


  _pyangbind_elements = OrderedDict([('tag_type', tag_type), ('priority', priority), ])


