# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc
import logging
from common.proto.context_pb2 import Empty
from monitoring.service.NameMapping import NameMapping
from common.proto.telemetry_frontend_pb2 import CollectorId, Collector, CollectorFilter, CollectorList
from common.method_wrappers.Decorator import MetricsPool, safe_and_metered_rpc_method
from common.proto.telemetry_frontend_pb2_grpc import TelemetryFrontendServiceServicer


LOGGER = logging.getLogger(__name__)
METRICS_POOL = MetricsPool('Monitoring', 'TelemetryFrontend')

class TelemetryFrontendServiceServicerImpl(TelemetryFrontendServiceServicer):
    def __init__(self, name_mapping : NameMapping):
        LOGGER.info('Init TelemetryFrontendService')

    @safe_and_metered_rpc_method(METRICS_POOL, LOGGER)
    def StartCollector(self, request : Collector, grpc_context: grpc.ServicerContext # type: ignore
        ) -> CollectorId: # type: ignore
        response = CollectorId()
        _collector_id = request.collector_id
        # collector_kpi_id = request.kpi_id
        # collector_duration = request.duration_s
        # collector_interval = request.interval_s

        response.collector_id.uuid = _collector_id.collector_id.uuid
        return response
    
    @safe_and_metered_rpc_method(METRICS_POOL, LOGGER)
    def StopCollector(self, request : CollectorId, grpc_context: grpc.ServicerContext # type: ignore
        ) -> Empty:  # type: ignore
        request.collector_id.uuid = ""
        return Empty()
    
    def SelectCollectors(self, request : CollectorFilter, contextgrpc_context: grpc.ServicerContext # type: ignore
        ) -> CollectorList:  # type: ignore
        response = CollectorList()
        
        return response