# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


def create_kafka_config_a(bootstrap_server: str, exporter_endpoint: str, kafka_topic: str,
                           run_duration: int, fetch_interval: int):
        """
        Provide ...
        Bootstrap_server IP address as String.
        Exporter endpoint with port <http://ip:port(metrics)> address as String.
        Kafka topic name as String.
        Total duration of the test as Int.
        Fetch_interval as Int.
        """
        _bootstrap_servers = bootstrap_server
        _exporter_endpoint = exporter_endpoint
        _kafka_topic       = kafka_topic
        _run_duration      = run_duration
        _fetch_interval    = fetch_interval

        return _bootstrap_servers, _exporter_endpoint, _kafka_topic, _run_duration, _fetch_interval
