package fabric

import org.hyperledger.fabric.gateway.Contract
import org.hyperledger.fabric.gateway.Gateway
import org.hyperledger.fabric.gateway.Wallet
import java.nio.file.Paths

// helper function for getting connected to the gateway
fun getContract(config: proto.Config.DltConfig, wallet: Wallet): Contract {
    // load a CCP
    val networkConfigPath = Paths.get(config.connectionFile)
    val builder = Gateway.createBuilder()
    builder.identity(wallet, config.user).networkConfig(networkConfigPath).discovery(true)
    val gateway = builder.connect()
    val network = gateway.getNetwork(config.channel)
    return network.getContract(config.contract)
}