import io.ktor.client.*
import io.ktor.client.engine.cio.*
import io.ktor.client.features.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.utils.io.jvm.javaio.*
import kotlinx.serialization.ExperimentalSerializationApi
import proto.Config
import proto.Config.DltConfig

@OptIn(ExperimentalSerializationApi::class)
suspend fun main(args: Array<String>) {
    // TODO: default configuration file
    val cfg = DltConfig.newBuilder().setWallet("wallet").setConnectionFile("config/connection-org1.json")
        .setUser("appUser")
        .setChannel("dlt")
        .setContract("basic").setCaCertFile("config/ca.org1.example.com-cert.pem").setCaUrl("https://s2:7054")
        .setCaAdmin("admin").setCaAdminSecret("adminpw").setMsp("Org1MSP").setAffiliation("org1.department1")
        .build()
    val cfgBytes = cfg.toByteArray()

    val client = HttpClient(CIO) {
        HttpResponseValidator {
            validateResponse { response ->
                println(response.status)
            }
        }
    }

    try {
        client.post<ByteArray>("http://localhost:8080/dlt/configure") {
            body = cfgBytes
        }
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

    try {
        val config = client.get<ByteArray>("http://localhost:8080/dlt/configure")
        println(DltConfig.parseFrom(config))
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

    val uuid = "41f4d2e2-f4ef-4c81-872a-c32f2d26b2ca"
    try {
        val record = client.get<ByteArray>("http://localhost:8080/dlt/record") {
            body = uuid
        }
        println(Config.DltRecord.parseFrom(record))
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

    val id = Config.DltRecordId.newBuilder().setUuid(uuid).build()
    val record = Config.DltRecord.newBuilder().setId(id).setOperation(Config.DltRecordOperation.ADD)
        .setType(Config.DltRecordType.DEVICE).setJson("{}").build()
    try {
        val result = client.post<ByteArray>("http://localhost:8080/dlt/record") {
            body = record.toByteArray()
        }
        println(String(result))
        val requestedRecord = client.get<ByteArray>("http://localhost:8080/dlt/record") {
            body = uuid
        }
        println(Config.DltRecord.parseFrom(requestedRecord))
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

    try {
        val newRecord = Config.DltRecord.newBuilder().setId(id).setOperation(Config.DltRecordOperation.UPDATE)
            .setType(Config.DltRecordType.SLICE).setJson("{}").build()
        val result = client.post<ByteArray>("http://localhost:8080/dlt/record") {
            body = newRecord.toByteArray()
        }
        println(String(result))
        val requestedRecord = client.get<ByteArray>("http://localhost:8080/dlt/record") {
            body = uuid
        }
        println(Config.DltRecord.parseFrom(requestedRecord))
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

    try {
        val newRecord = Config.DltRecord.newBuilder().setId(id).setOperation(Config.DltRecordOperation.DISABLE)
            .setType(Config.DltRecordType.SLICE).setJson("{}").build()
        val result = client.post<ByteArray>("http://localhost:8080/dlt/record") {
            body = newRecord.toByteArray()
        }
        println(String(result))
        val requestedRecord = client.get<ByteArray>("http://localhost:8080/dlt/record") {
            body = uuid
        }
        println(Config.DltRecord.parseFrom(requestedRecord))
    } catch (e: ClientRequestException) {
        println(e.response.status)
        println(String(e.response.content.toInputStream().readAllBytes()))
    }

}