import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

import com.google.protobuf.gradle.generateProtoTasks
import com.google.protobuf.gradle.id
import com.google.protobuf.gradle.protobuf
import com.google.protobuf.gradle.protoc

ext["protobufVersion"] = "3.19.1"
ext["ktorVersion"] = "1.6.5"

plugins {
    kotlin("jvm") version "1.5.31"
    kotlin("plugin.serialization") version "1.4.21"
    id("com.google.protobuf") version "0.8.17"
    application
}

group = "eu.neclab"
version = "1.0-SNAPSHOT"

repositories {
    mavenCentral()
}

dependencies {
    testImplementation("org.jetbrains.kotlin:kotlin-test:1.5.31")
    implementation("org.hyperledger.fabric:fabric-gateway-java:2.2.2")
    api("com.google.protobuf:protobuf-kotlin:${rootProject.ext["protobufVersion"]}")
    implementation("io.ktor:ktor-server-core:${rootProject.ext["ktorVersion"]}")
    implementation("io.ktor:ktor-server-netty:${rootProject.ext["ktorVersion"]}")
    implementation("io.ktor:ktor-serialization:${rootProject.ext["ktorVersion"]}")
    implementation("io.ktor:ktor-client-serialization:${rootProject.ext["ktorVersion"]}")
    implementation("io.ktor:ktor-client-core:${rootProject.ext["ktorVersion"]}")
    implementation("io.ktor:ktor-client-cio:${rootProject.ext["ktorVersion"]}")
    implementation("ch.qos.logback:logback-classic:1.2.5")
    implementation("org.jetbrains.kotlinx:kotlinx-serialization-json:1.3.1")
    implementation("org.jetbrains.kotlinx:kotlinx-serialization-protobuf:1.3.1")
}

tasks.test {
    useJUnitPlatform()
}

tasks.withType<KotlinCompile> {
    kotlinOptions.jvmTarget = "11"
}

tasks.withType<KotlinCompile>().all {
    kotlinOptions {
        freeCompilerArgs = listOf("-Xopt-in=kotlin.RequiresOptIn")
    }
}


application {
    mainClass.set("MainKt")
}

sourceSets {
    main {
        proto {
            srcDir("src/main/kotlin/proto")
        }
    }
}

protobuf {
    protoc {
        artifact = "com.google.protobuf:protoc:${rootProject.ext["protobufVersion"]}"
    }
    generateProtoTasks {
        all().forEach {
            it.builtins {
                id("kotlin")
            }
        }
    }
}