import functools
from enum import Enum
from device.proto.kpi_sample_types_pb2 import KpiSampleType
from .Tools import grpc_to_enum

class ORM_KpiSampleType(Enum):
    UNKNOWN             = KpiSampleType.UNKNOWN
    PACKETS_TRANSMITTED = KpiSampleType.PACKETS_TRANSMITTED
    PACKETS_RECEIVED    = KpiSampleType.PACKETS_RECEIVED
    BYTES_TRANSMITTED   = KpiSampleType.BYTES_TRANSMITTED
    BYTES_RECEIVED      = KpiSampleType.BYTES_RECEIVED

grpc_to_enum__kpi_sample_type = functools.partial(
    grpc_to_enum, KpiSampleType, ORM_KpiSampleType)
