/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import net.sourceforge.plantuml.Log;

public class PngIOMetadata {
    private static final String copyleft = "Generated by http://plantuml.sourceforge.net";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithMetadata(RenderedImage renderedImage, OutputStream outputStream, String string, int n, String string2) throws IOException {
        PNGMetadata pNGMetadata = new PNGMetadata();
        if (n != 96) {
            pNGMetadata.pHYs_present = true;
            pNGMetadata.pHYs_unitSpecifier = 1;
            pNGMetadata.pHYs_pixelsPerUnitYAxis = pNGMetadata.pHYs_pixelsPerUnitXAxis = (int)Math.round((double)n / 0.0254 + 0.5);
        }
        if (string != null) {
            pNGMetadata.zTXt_keyword.add("plantuml");
            pNGMetadata.zTXt_compressionMethod.add(new Integer(0));
            pNGMetadata.zTXt_text.add(string);
        }
        if (string2 != null) {
            pNGMetadata.tEXt_keyword.add("debug");
            pNGMetadata.tEXt_text.add(string2);
        }
        pNGMetadata.tEXt_keyword.add("copyleft");
        pNGMetadata.tEXt_text.add(copyleft);
        Log.debug("PngIOMetadata pngMetadata=" + pNGMetadata);
        IIOImage iIOImage = new IIOImage(renderedImage, null, (IIOMetadata)pNGMetadata);
        Log.debug("PngIOMetadata iioImage=" + iIOImage);
        ImageWriter imageWriter = PngIOMetadata.getImageWriter();
        Log.debug("PngIOMetadata imagewriter=" + imageWriter);
        ImageWriter imageWriter2 = imageWriter;
        synchronized (imageWriter2) {
            imageWriter.setOutput(ImageIO.createImageOutputStream(outputStream));
            imageWriter.write(null, iIOImage, null);
            outputStream.flush();
            imageWriter.reset();
            imageWriter.dispose();
        }
    }

    private static ImageWriter getImageWriter() {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        Iterator<ImageWriter> iterator2 = ImageIO.getImageWritersBySuffix("png");
        while (iterator2.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            Log.debug("PngIOMetadata countImageWriter = " + iterator2.next());
            if (!imageWriter.getClass().getName().equals("com.sun.imageio.plugins.png.PNGImageWriter")) continue;
            Log.debug("PngIOMetadata Found sun PNGImageWriter");
            return imageWriter;
        }
        Log.debug("Using first one");
        return ImageIO.getImageWritersBySuffix("png").next();
    }
}

