import sys
import grpc

from monitoring.proto import monitoring_pb2
from monitoring.proto import monitoring_pb2_grpc
from monitoring.proto import context_pb2

from common.logger import getJSONLogger
LOGGER = getJSONLogger('monitoring-client')
LOGGER.setLevel('DEBUG')

class MonitoringClient:

    def __init__(self, server='monitoring', port='7070'):
        endpoint = '{}:{}'.format(server, port)
        LOGGER.info('init monitoringClient {}'.format(endpoint))
        self.channel = grpc.insecure_channel(endpoint)
        self.server = monitoring_pb2_grpc.MonitoringServiceStub(self.channel)

    def CreateKpi(self, request):
        LOGGER.info('CreateKpi: {}'.format(request))
        response = self.server.CreateKpi(request)
        LOGGER.info('CreateKpi result: {}'.format(response))
        return monitoring_pb2.KpiId()

    def MonitorKpi(self, request):
        LOGGER.info('MonitorKpi: {}'.format(request))
        response = self.server.MonitorKpi(request)
        LOGGER.info('MonitorKpi result: {}'.format(response))
        return context_pb2.Empty()

    def IncludeKpi(self, request):
        LOGGER.info('IncludeKpi: {}'.format(request))
        response = self.server.IncludeKpi(request)
        LOGGER.info('IncludeKpi result: {}'.format(response))
        return context_pb2.Empty()

    def GetStreamKpi(self, request):
        LOGGER.info('GetStreamKpi: {}'.format(request))
        response = self.server.GetStreamKpi(request)
        LOGGER.info('GetStreamKpi result: {}'.format(response))
        yield monitoring_pb2.Kpi()

    def GetInstantKpi(self, request):
        LOGGER.info('GetInstantKpi: {}'.format(request))
        response = self.server.GetInstantKpi(request)
        LOGGER.info('GetInstantKpi result: {}'.format(response))
        return monitoring_pb2.Kpi()

    def GetKpiDescriptor(self, request):
        LOGGER.info('GetKpiDescriptor: {}'.format(request))
        response = self.server.GetKpiDescriptor(request)
        LOGGER.info('GetKpiDescriptor result: {}'.format(response))
        return monitoring_pb2.KpiDescriptor()

    def ListenEvents(self, ):
        LOGGER.info('ListenEvents: {}'.format())
        response = self.server.ListenEvents()
        LOGGER.info('ListenEvents result: {}'.format(response))
        return monitoring_pb2.KpiDescriptor()

if __name__ == '__main__':
    # get port
    port = sys.argv[1] if len(sys.argv) > 1 else '7070'

    # make call to server
    client = MonitoringClient(port=port)
