# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


from flask import current_app, render_template, Blueprint, flash, session, redirect, url_for
from common.proto.context_pb2 import Empty, OpticalLink, LinkId, OpticalLinkList
from common.tools.context_queries.EndPoint import get_endpoint_names
from common.tools.context_queries.Link import get_link
from common.tools.context_queries.Topology import get_topology
from context.client.ContextClient import ContextClient


base_optical = Blueprint('base_optical', __name__, url_prefix='/base_optical')

@base_optical.get('/')
def home():
    
    return render_template("base_optical/home.html")