import grpc, logging
from common.tools.client.RetryDecorator import retry, delay_exponential
from context.proto.context_pb2 import Link, LinkId, Empty, Topology
from context.proto.context_pb2_grpc import ContextServiceStub

LOGGER = logging.getLogger(__name__)
MAX_RETRIES = 15
DELAY_FUNCTION = delay_exponential(initial=0.01, increment=2.0, maximum=5.0)

class ContextClient:
    def __init__(self, address, port):
        self.endpoint = '{}:{}'.format(address, port)
        LOGGER.debug('Creating channel to {}...'.format(self.endpoint))
        self.channel = None
        self.stub = None
        self.connect()
        LOGGER.debug('Channel created')

    def connect(self):
        self.channel = grpc.insecure_channel(self.endpoint)
        self.stub = ContextServiceStub(self.channel)

    def close(self):
        if(self.channel is not None): self.channel.close()
        self.channel = None
        self.stub = None

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def GetTopology(self, request : Empty) -> Topology:
        LOGGER.debug('GetTopology request: {}'.format(request))
        response = self.stub.GetTopology(request)
        LOGGER.debug('GetTopology result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def AddLink(self, request : Link) -> LinkId:
        LOGGER.debug('AddLink request: {}'.format(request))
        response = self.stub.AddLink(request)
        LOGGER.debug('AddLink result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def DeleteLink(self, request : LinkId) -> Empty:
        LOGGER.debug('DeleteLink request: {}'.format(request))
        response = self.stub.DeleteLink(request)
        LOGGER.debug('DeleteLink result: {}'.format(response))
        return response
