/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.GeneralPath;
import net.sourceforge.plantuml.geom.Box;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;

abstract class AbstractPolyline
implements Polyline {
    private final Pointable start;
    private final Pointable end;

    public AbstractPolyline(Pointable pointable, Pointable pointable2) {
        this.start = pointable;
        this.end = pointable2;
    }

    public final String toString() {
        return this.segments().toString();
    }

    public final boolean doesTouch(Polyline polyline) {
        boolean bl = this.doesTouchInternal(polyline);
        assert (bl == ((AbstractPolyline)polyline).doesTouchInternal(this));
        return bl;
    }

    private boolean doesTouchInternal(Polyline polyline) {
        for (int i = 0; i < this.nbSegments(); ++i) {
            LineSegmentInt lineSegmentInt = this.segments().get(i);
            for (int j = 0; j < polyline.nbSegments(); ++j) {
                boolean bl;
                LineSegmentInt lineSegmentInt2 = polyline.segments().get(j);
                boolean bl2 = bl = i == 0 || i == this.nbSegments() - 1 || j == 0 || j == polyline.nbSegments() - 1;
                if (!bl && lineSegmentInt.doesIntersect(lineSegmentInt2)) {
                    return true;
                }
                if (!bl || !lineSegmentInt.doesIntersectButNotSameExtremity(lineSegmentInt2)) continue;
                return true;
            }
        }
        return false;
    }

    public final LineSegmentInt getFirst() {
        return this.segments().get(0);
    }

    public final LineSegmentInt getLast() {
        return this.segments().get(this.nbSegments() - 1);
    }

    public final double getLength() {
        double d = 0.0;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            d += lineSegmentInt.getLength();
        }
        return d;
    }

    public final Point2DInt clipStart(Box box) {
        assert (box.doesIntersect(this.segments().get(0)));
        Point2DInt[] point2DIntArray = box.intersect(this.segments().get(0));
        assert (point2DIntArray.length == 1);
        this.segments().set(0, new LineSegmentInt(point2DIntArray[0].getXint(), point2DIntArray[0].getYint(), this.segments().get(0).getP2().getXint(), this.segments().get(0).getP2().getYint()));
        return point2DIntArray[0];
    }

    public final Point2DInt clipEnd(Box box) {
        int n = this.nbSegments() - 1;
        if (n == -1) {
            return null;
        }
        assert (box.doesIntersect(this.segments().get(n)));
        Point2DInt[] point2DIntArray = box.intersect(this.segments().get(n));
        assert (point2DIntArray.length == 1);
        this.segments().set(n, new LineSegmentInt(this.segments().get(n).getP1().getXint(), this.segments().get(n).getP1().getYint(), point2DIntArray[0].getXint(), point2DIntArray[0].getYint()));
        return point2DIntArray[0];
    }

    public final boolean intersectBox(Box box) {
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            if (!box.doesIntersect(lineSegmentInt)) continue;
            return true;
        }
        return false;
    }

    public final double getDistance(Box box) {
        double d = Double.MAX_VALUE;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            if (!box.doesIntersect(lineSegmentInt)) continue;
            d = Math.min(d, lineSegmentInt.getDistance(box.getCenterPoint()));
        }
        return d;
    }

    public final double getDistance(Polyline polyline) {
        double d = 0.0;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            for (LineSegmentInt lineSegmentInt2 : polyline.segments()) {
                d += lineSegmentInt.getDistance(lineSegmentInt2);
            }
        }
        return d;
    }

    public final GeneralPath asGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            generalPath.append(lineSegmentInt, false);
        }
        return generalPath;
    }

    public final int getMinX() {
        int n = Integer.MAX_VALUE;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            n = Math.min(n, lineSegmentInt.getMinX());
        }
        return n;
    }

    public final int getMinY() {
        int n = Integer.MAX_VALUE;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            n = Math.min(n, lineSegmentInt.getMinY());
        }
        return n;
    }

    public final int getMaxX() {
        int n = Integer.MIN_VALUE;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            n = Math.max(n, lineSegmentInt.getMaxX());
        }
        return n;
    }

    public final int getMaxY() {
        int n = Integer.MIN_VALUE;
        for (LineSegmentInt lineSegmentInt : this.segments()) {
            n = Math.max(n, lineSegmentInt.getMaxY());
        }
        return n;
    }

    public final Pointable getStart() {
        return this.start;
    }

    public final Pointable getEnd() {
        return this.end;
    }
}

