/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityPlus
extends Extremity {
    private final UEllipse circle;
    private final double px;
    private final double py;
    private final double radius = 8.0;
    private final double angle;

    public ExtremityPlus(Point2D point2D, double d) {
        this.angle = d;
        this.circle = new UEllipse(16.0, 16.0);
        this.px = point2D.getX() - 8.0 + 8.0 * Math.sin(d);
        this.py = point2D.getY() - 8.0 - 8.0 * Math.cos(d);
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic.apply(new UChangeBackColor(HtmlColorUtils.WHITE)).apply(new UTranslate(this.px + 0.0, this.py + 0.0)).draw(this.circle);
        ExtremityPlus.drawLine(uGraphic, 0.0, 0.0, this.getPointOnCircle(this.angle - 1.5707963267948966), this.getPointOnCircle(this.angle + 1.5707963267948966));
        ExtremityPlus.drawLine(uGraphic, 0.0, 0.0, this.getPointOnCircle(this.angle), this.getPointOnCircle(this.angle + Math.PI));
    }

    private Point2D getPointOnCircle(double d) {
        double d2 = this.px + 8.0 + 8.0 * Math.cos(d);
        double d3 = this.py + 8.0 + 8.0 * Math.sin(d);
        return new Point2D.Double(d2, d3);
    }

    private static void drawLine(UGraphic uGraphic, double d, double d2, Point2D point2D, Point2D point2D2) {
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        uGraphic.apply(new UTranslate(d + point2D.getX(), d2 + point2D.getY())).draw(new ULine(d3, d4));
    }
}

