## Instantiating SAREF4GRID


This clause shows different examples of how to instantiate the SAREF4GRID extension of SAREF. 


The example presented in Figure 20 depicts an electric grid meter (_ex:Meter1234_). It can be described by a set of meter properties (such as the one shown in the figure, _ex:ScrollDisplayMode_) that are identified by an OBIS code (_s4grid:hasObis_). Notice that some meter properties do not specify a unit of measure.


SAREF4GRID does not aim to provide an exhaustive definition of all the properties defined in IEC 62056-6-2 [i.4]. Instead, it defines a set of general properties (those shown in Figure 6, e.g. _s4grid:ScreenDisplay_ in the figure) and specific properties can be related to these general properties using the SKOS ontology [i.5]. Using SKOS more specific properties can be defined specifying from which general property they are derived (_skos:narrower_), and which properties belong to a general property (_skos:broader_).

<figure>
    <img data-docx-width="16.66cm" src="diagrams/SAREF4GRID_Example_meter_1.png" alt="Example of electric grid meter information I"/>
    <figcaption>Figure 20: Example of electric grid meter information I</figcaption>
</figure>


The example presented in Figure 21 depicts an electric grid meter (_ex:Meter1234_). It can be described by a set of meter properties (e.g. _ex:ActivePowerLimitContract1TariffPeriod1_) which are identified by an OBIS code (_s4grid:hasObis_). The meter properties used to describe a meter are broader than the properties shown in Figure 6 (e.g. _s4grid:PowerLimit_). Notice that some meter properties specify a unit of measure (e.g. _om:watt_).

<figure>
    <img data-docx-width="16.68cm" src="diagrams/SAREF4GRID_Example_meter_2.png" alt="Example of electric grid meter information II"/>
    <figcaption>Figure 21: Example of electric grid meter information II</figcaption>
</figure>


Unlike other SAREF extensions, a meter firmware is not defined by a datatype property. The example presented in Figure 22 depicts a meter firmware (e.g. _ex:ActivePLCFirmware_) which is represented by an OBIS code (_s4grid:hasObis_).

<figure>
    <img data-docx-width="16.72cm" src="diagrams/SAREF4GRID_Example_firmware.png" alt="Example of electric grid meter firmware"/>
    <figcaption>Figure 22: Example of electric grid meter firmware</figcaption>
</figure>


Figure 23 contains an example of a network interface (_ex:MacAddress1234_) defined for a meter. Moreover, the network interface is represented by an OBIS code (_s4grid:hasObis_).

<figure>
    <img data-docx-width="16.45cm" src="diagrams/SAREF4GRID_Example_network_interface.png" alt="Example of electric grid meter network interface"/>
    <figcaption>Figure 23: Example of electric grid meter network interface</figcaption>
</figure>


Figure 24 contains an example of a meter clock (_ex:Clock1234_). Moreover, the clock is represented by an OBIS code (_s4grid:hasObis_). Notice that the clock is not only represented by a time (_s4grid:hasTime_) but is also represented by the time zone in which it is located and how the time is changed.

<figure>
    <img data-docx-width="16.72cm" src="diagrams/SAREF4GRID_Example_clock.png" alt="Example of electric grid meter clock"/>
    <figcaption>Figure 24: Example of electric grid meter clock</figcaption>
</figure>


Figure 25 contains an example of a meter breaker state (_ex:CurrentBreakerState_). In this example, it is represented that the meter is physically connected (_s4grid:hasOutputState_), internally connected (_s4grid:hasControlState_), and it can be remotely, manually and locally disconnected (_s4grid:hasControlMode_). Moreover, the breaker state is represented by an OBIS code (_s4grid:hasObis_).




<figure>
    <img data-docx-width="16.60cm" src="diagrams/SAREF4GRID_Example_breaker_state.png" alt="Example of electric grid meter breaker state"/>
    <figcaption>Figure 25: Example of electric grid meter breaker state</figcaption>
</figure>


Figure 26 contains an example of how scripts (_ex:ConnectionScript_ and _ex:DisconnectionScript_) are stored in the meter. A script table (_ex:DisconnectScriptTable_) is needed in order to represent where the scripts are located. Moreover, a single scheduled action (_ex:DisconnectControlScheduler_) is used to represent that a script is going to be executed in a determined date. Moreover, the script table and single scheduled action are represented by an OBIS code (_s4grid:hasObis_).

<figure>
    <img data-docx-width="16.70cm" src="diagrams/SAREF4GRID_Example_script.png" alt="Example of electric grid meter script table and scheduled action"/>
    <figcaption>Figure 26: Example of electric grid meter script table and scheduled action</figcaption>
</figure>


Figure 27 contains an example of how an activity calendar (_ex:ActivityCalendarContract1-1234_) is represented in a meter. This activity calendar is represented by an active season profile (_ex:SeasonActive1_) that is described by the date at which it starts and two regular day profiles: one that describes working days (_ex:WeekDay_) and other that describes weekend days (_ex:WeekendDay_). Each day profile is represented by when a billing period starts each day (_ex:WeekDayTariffPeriod1_ and _ex:WeekendDayTariffPeriod1_) and what scripts need to be executed to make the billing (_ex:ResetBillingPeriod1_ and _ex:ResetBillingPeriod2_). Additionally, a special day profile (_ex:SpecialFriday1_) defines which days are special (e.g. festive) and, therefore, another tariffication is going to be applied. Moreover, the activity calendar is represented by an OBIS code (_s4grid:hasObis_). Notice that just the active calendar is represented (e.g. the passive calendar associated to the active calendar is not represented) in order to simplify the example.

<figure>
    <img data-docx-width="16.89cm" src="diagrams/SAREF4GRID_Example_activity_calendar.png" alt="Example of electric grid meter activity calendar"/>
    <figcaption>Figure 27: Example of electric grid meter activity calendar</figcaption>
</figure>


One of the main functions of electric grid meters is to take measures from a power line in order to control what is happening in the electric grid. Figure 28 presents an example of a power line observation (_ex:TotalIncrementalActiveEnergyImportObservation123_) for a power line property (_ex:TotalIncrementalActiveEnergyImport_) that is identified by an OBIS code (_s4grid:hasObis_). 


As with meter properties, SAREF4GRID does not aim to provide an exhaustive definition of all the properties defined in IEC 62056-6-2 [i.4]. Instead, it defines a set of general properties (those shown in Figure 14 and Figure 15, e.g. _s4grid:ActiveEnergy_ in the figure) and specific properties can be related to these general properties using the SKOS ontology [i.5]. Using SKOS more specific properties can be defined specifying from which general property they are derived (_skos:narrower_), and which properties belong to a general property (_skos:broader_).

<figure>
    <img data-docx-width="16.73cm" src="diagrams/SAREF4GRID_Example_measurement_1.png" alt="Example of electric grid meter observations I"/>
    <figcaption>Figure 28: Example of electric grid meter observations I</figcaption>
</figure>


Figure 29 presents another example of a power line observation (_ex:MaximumDemandRegisterImportC1TP1Observation136_) for a power line property (_ex:MaximumDemandRegisterImportC1TP1_) that is identified by an OBIS code (_s4grid:hasObis_). The power line properties are broader than the properties shown in Figure 14 and Figure 15 (e.g. _s4grid:DemandRegister_).

<figure>
    <img data-docx-width="16.71cm" src="diagrams/SAREF4GRID_Example_measurement_2.png" alt="Example of electric grid meter observations II"/>
    <figcaption>Figure 29: Example of electric grid meter observations II</figcaption>
</figure>


Different profile generics can be generated in order to access data groups that are stored in an electric grid meter. Figure 30 presents an example of a profile generic (_ex:IncrementalLoadProfile1234_) whose objective is to store the incremental energy values that a meter measures (_ex:Observation1_ to _ex:Observation6_) each hour. Additionally, the profile generic stores the clock (_ex:Clock1234_) to indicate the time at which the profile generic captures elements, and the AMR status (_ex:PropertyValue1_) that the meter stores. Moreover, the profile generic is represented by an OBIS code (_s4grid:hasObis_).

<figure>
    <img data-docx-width="16.58cm" src="diagrams/SAREF4GRID_Example_profile.png" alt="Example of electric grid meter profile generic"/>
    <figcaption>Figure 30: Example of electric grid meter profile generic</figcaption>
</figure>


Each element that a meter stores can be obtained through a get service. Figure 31 presents an example of how it is specified that a COSEM element is going to be obtained. A get service (_ex:GetServiceIncrementalLoadProfile_) is executed through a get operation (_ex:GetOperationIncrementalLoadProfile_). This operation indicates the desired input (_ex:OperationInputIncrementalLoadProfile_), which in this case specifies the element from which data is going to be retrieved, and the desired output (_ex:OutputIncrementalLoadProfile_), which in this case specifies the data structure that is going to be given.

<figure>
    <img data-docx-width="16.83cm" src="diagrams/SAREF4GRID_Example_get_1.png" alt="Example of electric grid meter get service I"/>
    <figcaption>Figure 31: Example of electric grid meter get service I</figcaption>
</figure>


Figure 32 presents an example of how it is specified that an attribute of a COSEM element is going to be obtained. Notice that in this example, the attribute corresponds to a datatype property of the SAREF4GRID ontology. A get service (_ex:GetServiceCapturePeriodIncrementalLoadProfile_) is executed through a get operation (_ex:GetOperationCapturePeriodIncrementalLoadProfile_). This operation indicates the desired input (_ex:OperationInputCapturePeriodIncrementalLoadProfile_), which in this case specifies the datatype property of the element from which data is going to be retrieved, and the desired output (_ex:OutputCapturePeriodIncrementalLoadProfile_), which in this case specifies the datatype that is going to be given.

<figure>
    <img data-docx-width="16.95cm" src="diagrams/SAREF4GRID_Example_get_2.png" alt="Example of electric grid meter get service II"/>
    <figcaption>Figure 32: Example of electric grid meter get service II</figcaption>
</figure>


Figure 33 presents an example of how it is specified that an attribute of a COSEM element is going to be obtained. Notice that in this example, the attribute corresponds to an object property of the SAREF4GRID ontology. A get service (_ex:GetServiceDisconnectionScript_) is executed through a get operation (_ex:GetOperationDisconnectionScript_). This operation indicates the desired input (_ex:OperationInputDisconnectionScript_), which in this case specifies the object property of the element from which data is going to be retrieved, and the desired output (_ex:OutputDisconnectionScript_), which in this case specifies the data structure that is going to be given.

<figure>
    <img data-docx-width="16.95cm" src="diagrams/SAREF4GRID_Example_get_3.png" alt="Example of electric grid meter get service III"/>
    <figcaption>Figure 33: Example of electric grid meter get service III</figcaption>
</figure>


Property-related services in get operations usually refer to the entire property. However, in the case of certain properties, selective access to only part of the property may be provided. Figure 34 presents an example of how it is specified that a range of values are going to be retrieved from a profile generic. A selective range get service (_ex:GetServiceIncrementalLoadProfileRange_) is executed through a get operation (_ex:GetOperationIncrementalLoadProfileRange_).


This operation indicates the desired input (_ex:OperationInputIncrementalLoadProfileRange_), which in this case specifies the element from which data is going to be retrieved, and the desired output (_ex:OutputIncrementalLoadProfileRange_), which in this case specifies the data structure that is going to be given. Additionally, a selective access with a range descriptor (_ex:RangeDescriptor1_) indicates that just the entries whose value is between 1 and 10 are going to be retrieved.

<figure>
    <img data-docx-width="15.20cm" src="diagrams/SAREF4GRID_Example_get_4.png" alt="Example of electric grid meter get service IV"/>
    <figcaption>Figure 34: Example of electric grid meter get service IV</figcaption>
</figure>


Figure 35 presents an example of how it is specified that a range of entries are going to be retrieved from a profile generic. A selective entry get service (_ex:GetServiceIncrementalLoadProfileEntry_) is executed through a get operation (_ex: GetOperationIncrementalLoadProfileEntry_). This operation indicates the desired input (_ex:OperationInputIncrementalLoadProfileEntry_), which in this case specifies the element from which data is going to be retrieved, and the desired output (_ex:OutputIncrementalLoadProfileEntry_), which in this case specifies the data structure that is going to be given. Additionally, a selective access with an entry descriptor (_ex:EntryDescriptor1_) indicates that just the top 10 entries are going to be retrieved.

<figure>
    <img data-docx-width="15.03cm" src="diagrams/SAREF4GRID_Example_get_5.png" alt="Example of electric grid meter get service V"/>
    <figcaption>Figure 35: Example of electric grid meter get service V</figcaption>
</figure>


Each element that a meter stores can be modified through a set service. Figure 36 presents an example of how it is specified that a COSEM element is going to be modified. A set service (_ex:SetMulticastCommunicationIdentifier_) is executed through a set operation (_ex:SetOperationMulticastCommunicationIdentifier_). This operation indicates the desired input (_ex:InputMulticastCommunicationIdentifier_), which in this case specifies the element from which data is going to be modified and the data structure that is going to replace the previous data.

<figure>
    <img data-docx-width="17.00cm" src="diagrams/SAREF4GRID_Example_set_1.png" alt="Example of electric grid meter set service I"/>
    <figcaption>Figure 36: Example of electric grid meter set service I</figcaption>
</figure>


Figure 37 presents an example of how it is specified that an attribute of a COSEM element is going to be modified. Notice that in this example, the attribute corresponds to a datatype property of the SAREF4GRID ontology. A set service (_ex:SetServiceCapturePeriodIncrementalLoadProfile_) is executed through a set operation (_ex:SetOperationCapturePeriodIncrementalLoadProfile_). This operation indicates the desired input (_ex:InputICapturePeriodIncrementalLoadProfile_), which in this case specifies the datatype property of the element from which data is going to be modified and the data type that is going to replace the previous data.

<figure>
    <img data-docx-width="17.00cm" src="diagrams/SAREF4GRID_Example_set_2.png" alt="Example of electric grid meter set service II"/>
    <figcaption>Figure 37: Example of electric grid meter set service II</figcaption>
</figure>


Figure 38 presents an example of how it is specified that an attribute of a COSEM element is going to be modified. Notice that in this example, the attribute corresponds to an object property of the SAREF4GRID ontology. A set service (_ex:SetServiceDisconnectionScript_) is executed through a set operation (_ex:SetOperationDisconnectionScript_). This operation indicates the desired input (_ex:InputIDisconnectionScript_), which in this case specifies the object property of the element from which data is going to be modified and the data structure that is going to replace the previous data.

<figure>
    <img data-docx-width="17.00cm" src="diagrams/SAREF4GRID_Example_set_3.png" alt="Example of electric grid meter set service III"/>
    <figcaption>Figure 38: Example of electric grid meter set service III</figcaption>
</figure>


Each element that a meter stores can be affected through an action service. Figure 39 presents an example of how it is specified that a COSEM element is going to be affected by an action. Notice that in this example the input parameter needed to execute the action is simple (e.g. integer, string, etc.). An action service (_ex:ResetServiceRegister_) is executed through an action operation (_ex:ResetServiceOperation_). This operation indicates the desired input (_ex:ResetServiceOperationInput_), which in this case specifies the element that is going to be affected by the action and the value of the parameter needed by the action.

<figure>
    <img data-docx-width="11.70cm" src="diagrams/SAREF4GRID_Example_action_1.png" alt="Example of electric grid meter action service I"/>
    <figcaption>Figure 39: Example of electric grid meter action service I</figcaption>
</figure>


Figure 40 presents an example of how it is specified that a COSEM element is going to be affected by an action. Notice that in this example the input parameter needed to execute the action is a structure. An action service (_ex:PresetAdjustingTimeServiceClock_) is executed through an action operation (_ex:PresetAdjustingTimeOperation_). This operation indicates the desired input (_ex:PresetAdjustingTime1_), which in this case specifies the element that is going to be affected by the action and the values of the parameter structure needed by the action.

<figure>
    <img data-docx-width="14.18cm" src="diagrams/SAREF4GRID_Example_action_2.png" alt="Example of electric grid meter action service II"/>
    <figcaption>Figure 40: Example of electric grid meter action service II</figcaption>
</figure>


Figure 41 presents an example of how it is specified that a COSEM element is going to be affected by an action. Notice that in this example the input parameter needed to execute the action is a structure. An action service (_ex:SpecialDayEntryServiceActivityCalendar_) is executed through an action operation (_ex:SpecialDayEntryOperation_). This operation indicates the desired input (_ex:SpecialDayEntry1_), which in this case specifies the element that is going to be affected by the action and the values of the parameter structure needed by the action.

<figure>
    <img data-docx-width="14.29cm" src="diagrams/SAREF4GRID_Example_action_3.png" alt="Example of electric grid meter action service III"/>
    <figcaption>Figure 41: Example of electric grid meter action service III</figcaption>
</figure>


## Discussion


In the following paragraphs, several observations about the SAREF4GRID ontology and its usage are mentioned.


The hierarchies and individuals defined in the extension should not be considered exhaustive. It might be needed to extend the hierarchies and lists of individuals for particular use cases, as well as to specialize some of the defined classes.


All the structures and individuals have been extracted from the DLMS/COSEM standard. In that standard, all the elements are identified by an OBIS code which is necessary to keep in the ontology.



